/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk.v1;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.fbpk.FBPK_Partition;
import ghidra.file.formats.android.fbpk.FBPT;
import ghidra.file.formats.android.fbpk.v1.FBPTv1;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class FBPKv1_Partition
extends FBPK_Partition {
    private int dataSize;
    private int unknown1;
    private int offsetToNextPartitionTable;
    private int unknown2;
    private FBPTv1 fbpt;
    private long dataStartOffset;

    public FBPKv1_Partition(BinaryReader reader) throws IOException {
        long start = reader.getPointerIndex();
        this.type = reader.readNextInt();
        this.name = reader.readNextAsciiString(36);
        this.dataSize = reader.readNextInt();
        this.unknown1 = reader.readNextInt();
        this.offsetToNextPartitionTable = reader.readNextInt();
        this.unknown2 = reader.readNextInt();
        this.headerSize = (int)(reader.getPointerIndex() - start);
        if (this.type == 0) {
            this.fbpt = new FBPTv1(reader);
        } else if (this.type == 1) {
            this.dataStartOffset = reader.getPointerIndex();
        }
    }

    public FBPT getFBPT() {
        return this.fbpt;
    }

    @Override
    public long getDataStartOffset() {
        return this.dataStartOffset;
    }

    @Override
    public int getDataSize() {
        return this.dataSize;
    }

    @Override
    public int getOffsetToNextPartitionTable() {
        return this.offsetToNextPartitionTable;
    }

    public boolean isDirectory() {
        return this.getType() == 0;
    }

    @Override
    public boolean isFile() {
        return this.getType() == 1;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    @Override
    public void markup(Program program, Address address, TaskMonitor monitor, MessageLog log) throws Exception {
        super.markup(program, address, monitor, log);
        if (this.isDirectory()) {
            if (this.fbpt != null) {
                this.fbpt.processFBPT(program, address.add((long)this.headerSize), monitor, log);
            }
        } else if (this.isFile()) {
            // empty if block
        }
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(FBPKv1_Partition.class.getSimpleName(), 0);
        struct.add(DWORD, "type", null);
        struct.add(STRING, 36, "name", null);
        struct.add(DWORD, "dataSize", null);
        struct.add(DWORD, "unknown1", null);
        struct.add(DWORD, "offsetToNextPartitionTable", null);
        struct.add(DWORD, "unknown2", null);
        return struct;
    }
}

