/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.io;

import org.catacombae.io.Readable;
import org.catacombae.io.RuntimeIOException;

public abstract class BasicReadable
implements Readable {
    protected BasicReadable() {
    }

    public int read() throws RuntimeIOException {
        byte[] res = new byte[1];
        if (this.read(res, 0, 1) == 1) {
            return res[0] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] data) throws RuntimeIOException {
        return this.read(data, 0, data.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws RuntimeIOException;

    public void readFully(byte[] data) throws RuntimeIOException {
        this.readFully(data, 0, data.length);
    }

    public void readFully(byte[] data, int offset, int length) throws RuntimeIOException {
        int curBytesRead;
        if (length < 0) {
            throw new IllegalArgumentException("length is negative: " + length);
        }
        for (int bytesRead = 0; bytesRead < length; bytesRead += curBytesRead) {
            curBytesRead = this.read(data, offset + bytesRead, length - bytesRead);
            if (curBytesRead > 0) {
                continue;
            }
            throw new RuntimeIOException("Couldn't read the entire length.");
        }
    }
}

