/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.pathmanager;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class AbstractTypedPropertyEditor<T>
implements PropertyEditor {
    private final List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private T value = this.getInitialValue();

    protected T getInitialValue() {
        return null;
    }

    protected T cast(Object value) {
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object value) {
        List<PropertyChangeListener> listeners;
        T oldValue;
        T newValue = this.cast(value);
        if (Objects.equals(newValue, this.value)) {
            return;
        }
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            oldValue = this.value;
            this.value = newValue;
            if (this.listeners.isEmpty()) {
                return;
            }
            listeners = List.copyOf(this.listeners);
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this, null, oldValue, newValue);
        for (PropertyChangeListener l : listeners) {
            l.propertyChange(evt);
        }
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        return "???";
    }

    protected String toText(T value) {
        return Objects.toString(value);
    }

    @Override
    public String getAsText() {
        return this.toText(this.value);
    }

    protected abstract T fromText(String var1);

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(this.fromText(text));
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }
}

