/*
 * Decompiled with CFR 0.152.
 */
package docking.theme.gui;

import docking.theme.gui.GThemeValuesCache;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import generic.theme.FontModifier;
import generic.theme.FontValue;
import generic.theme.GThemeValueMap;
import generic.theme.Gui;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JLabel;

public class ThemeFontTableModel
extends GDynamicColumnTableModel<FontValue, Object> {
    private List<FontValue> fonts;
    private GThemeValueMap currentValues;
    private GThemeValueMap themeValues;
    private GThemeValueMap defaultValues;
    private GThemeValuesCache valuesProvider;
    private boolean showSystemValues;

    public ThemeFontTableModel(GThemeValuesCache valuesProvider) {
        super((ServiceProvider)new ServiceProviderStub());
        this.valuesProvider = valuesProvider;
        this.load();
    }

    public void setShowSystemValues(boolean show) {
        this.showSystemValues = show;
    }

    public boolean isShowingSystemValues() {
        return this.showSystemValues;
    }

    protected void filter() {
        ArrayList<FontValue> filtered = new ArrayList<FontValue>();
        for (FontValue fontValue : this.fonts) {
            String id = fontValue.getId();
            if (this.showSystemValues) {
                filtered.add(fontValue);
                continue;
            }
            if (Gui.isSystemId((String)id)) continue;
            filtered.add(fontValue);
        }
        this.fonts = filtered;
    }

    public void reloadCurrent() {
        this.currentValues = this.valuesProvider.getCurrentValues();
        this.fonts = this.currentValues.getFonts();
        this.fireTableDataChanged();
    }

    public void reloadAll() {
        this.load();
        this.fireTableDataChanged();
    }

    private void load() {
        this.currentValues = this.valuesProvider.getCurrentValues();
        this.fonts = this.currentValues.getFonts();
        this.themeValues = this.valuesProvider.getThemeValues();
        this.defaultValues = this.valuesProvider.getDefaultValues();
        this.filter();
    }

    @Override
    public String getName() {
        return "Fonts";
    }

    @Override
    public List<FontValue> getModelData() {
        return this.fonts;
    }

    @Override
    protected TableColumnDescriptor<FontValue> createTableColumnDescriptor() {
        TableColumnDescriptor<FontValue> descriptor = new TableColumnDescriptor<FontValue>();
        descriptor.addVisibleColumn(new IdColumn(this));
        descriptor.addVisibleColumn(new FontValueColumn("Current Font", () -> this.currentValues));
        descriptor.addVisibleColumn(new FontValueColumn("Theme Font", () -> this.themeValues));
        descriptor.addVisibleColumn(new FontValueColumn("Default Font", () -> this.defaultValues));
        return descriptor;
    }

    @Override
    public Object getDataSource() {
        return null;
    }

    public FontValue getThemeValue(String id) {
        return this.themeValues.getFont(id);
    }

    private String getValueText(ResolvedFont resolvedFont) {
        if (resolvedFont == null) {
            return "<No Value>";
        }
        if (resolvedFont.refId() != null) {
            return resolvedFont.getValueText();
        }
        Font font = resolvedFont.font();
        return FontValue.fontToString((Font)font);
    }

    private class IdColumn
    extends AbstractDynamicTableColumn<FontValue, String, Object> {
        private IdColumn(ThemeFontTableModel themeFontTableModel) {
        }

        @Override
        public String getColumnName() {
            return "Id";
        }

        @Override
        public String getValue(FontValue fontValue, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            return fontValue.getId();
        }

        @Override
        public int getColumnPreferredWidth() {
            return 300;
        }
    }

    private class FontValueColumn
    extends AbstractDynamicTableColumn<FontValue, ResolvedFont, Object> {
        private ThemeFontRenderer renderer;
        private String name;
        private Supplier<GThemeValueMap> valueSupplier;

        FontValueColumn(String name, Supplier<GThemeValueMap> supplier) {
            this.name = name;
            this.valueSupplier = supplier;
            this.renderer = new ThemeFontRenderer();
        }

        @Override
        public String getColumnName() {
            return this.name;
        }

        @Override
        public ResolvedFont getValue(FontValue themeFont, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
            String id;
            GThemeValueMap valueMap = this.valueSupplier.get();
            FontValue fontValue = valueMap.getFont(id = themeFont.getId());
            if (fontValue == null) {
                return null;
            }
            return new ResolvedFont(fontValue, id, fontValue.getReferenceId(), valueMap.getResolvedFont(id));
        }

        @Override
        public GColumnRenderer<ResolvedFont> getColumnRenderer() {
            return this.renderer;
        }

        @Override
        public Comparator<ResolvedFont> getComparator() {
            return (v1, v2) -> {
                if (v1 == null && v2 == null) {
                    return 0;
                }
                if (v1 == null) {
                    return 1;
                }
                if (v2 == null) {
                    return -1;
                }
                return ThemeFontTableModel.this.getValueText((ResolvedFont)v1).compareTo(ThemeFontTableModel.this.getValueText((ResolvedFont)v2));
            };
        }

        @Override
        public int getColumnPreferredWidth() {
            return 300;
        }
    }

    private record ResolvedFont(FontValue fontValue, String id, String refId, Font font) {
        String getValueText() {
            if (this.refId == null) {
                return FontValue.fontToString((Font)this.font);
            }
            FontModifier modifier = this.fontValue.getModifier();
            String modifierText = "";
            if (modifier != null) {
                modifierText = "*";
            }
            return "[" + this.refId + "]" + modifierText;
        }

        String getFullValueText() {
            if (this.refId == null) {
                return FontValue.fontToString((Font)this.font);
            }
            FontModifier modifier = this.fontValue.getModifier();
            String modifierText = "";
            if (modifier != null) {
                modifierText = "    [%s]%s".formatted(this.refId, modifier.toString());
            }
            return FontValue.fontToString((Font)this.font) + modifierText;
        }
    }

    private class ThemeFontRenderer
    extends AbstractGColumnRenderer<ResolvedFont> {
        private ThemeFontRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(data);
            ResolvedFont resolvedFont = (ResolvedFont)data.getValue();
            String text = ThemeFontTableModel.this.getValueText(resolvedFont);
            label.setText(text);
            label.setOpaque(true);
            Font font = resolvedFont.font();
            if (font != null) {
                this.setToolTipText(resolvedFont.getFullValueText());
            }
            return label;
        }

        @Override
        public String getFilterString(ResolvedFont resolvedFont, Settings settings) {
            return ThemeFontTableModel.this.getValueText(resolvedFont);
        }
    }
}

