/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractFileSystem<METADATATYPE>
implements GFileSystem {
    protected final FileSystemService fsService;
    protected final FSRLRoot fsFSRL;
    protected FileSystemIndexHelper<METADATATYPE> fsIndex;
    protected FileSystemRefManager refManager = new FileSystemRefManager(this);

    protected AbstractFileSystem(FSRLRoot fsFSRL, FileSystemService fsService) {
        this.fsService = fsService;
        this.fsFSRL = fsFSRL;
        this.fsIndex = new FileSystemIndexHelper(this, fsFSRL);
    }

    @Override
    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    @Override
    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    @Override
    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    protected Comparator<String> getFilenameComparator() {
        return null;
    }

    @Override
    public GFile lookup(String path) {
        return this.fsIndex.lookup(null, path, this.getFilenameComparator());
    }

    @Override
    public GFile lookup(String path, Comparator<String> nameComp) throws IOException {
        return this.fsIndex.lookup(null, path, nameComp);
    }

    @Override
    public GFile getRootDir() {
        return this.fsIndex.getRootDir();
    }

    @Override
    public List<GFile> getListing(GFile directory) {
        return this.fsIndex.getListing(directory);
    }

    @Override
    public int getFileCount() {
        return this.fsIndex.getFileCount();
    }

    @Override
    public GFile resolveSymlinks(GFile file) throws IOException {
        return this.fsIndex.resolveSymlinks(file);
    }

    public String toString() {
        return this.getName();
    }
}

