/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.resource;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.pe.resource.VS_VERSION_CHILD;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public class VS_VERSION_INFO
implements StructConverter {
    public static final String NAME = "VS_VERSION_INFO";
    public static final int SIZEOF = 92;
    private short structLength;
    private short valueLength;
    private short structType;
    private String info;
    private int alignment;
    private int signature;
    private String structVersion;
    private String fileVersion;
    private String productVersion;
    private String fileFlagsMask;
    private int fileFlags;
    private int fileOS;
    private int fileType;
    private int fileSubtype;
    private int fileTimestamp;
    private ArrayList<VS_VERSION_CHILD> children = new ArrayList();
    private HashMap<String, String> valueMap = new HashMap();

    public VS_VERSION_INFO(BinaryReader reader, int index) throws IOException {
        long oldIndex = reader.getPointerIndex();
        reader.setPointerIndex(index);
        this.structLength = reader.readNextShort();
        this.valueLength = reader.readNextShort();
        this.structType = reader.readNextShort();
        this.info = reader.readNextUnicodeString();
        this.alignment = reader.align(4);
        this.signature = reader.readNextInt();
        this.structVersion = VS_VERSION_INFO.shortArrayToString(reader, 2);
        this.fileVersion = VS_VERSION_INFO.shortArrayToString(reader, 4);
        this.productVersion = VS_VERSION_INFO.shortArrayToString(reader, 4);
        this.fileFlagsMask = VS_VERSION_INFO.intArrayToString(reader, 2);
        this.fileFlags = reader.readNextInt();
        this.fileOS = reader.readNextInt();
        this.fileType = reader.readNextInt();
        this.fileSubtype = reader.readNextInt();
        this.fileTimestamp = reader.readNextInt();
        while (reader.getPointerIndex() < (long)(index + this.structLength)) {
            this.children.add(new VS_VERSION_CHILD(reader, reader.getPointerIndex() - (long)index, null, this.valueMap));
        }
        reader.setPointerIndex(oldIndex);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(WORD, "StructLength", null);
        struct.add(WORD, "ValueLength", null);
        struct.add(WORD, "StructType", null);
        struct.add(UTF16, (this.info.length() + 1) * 2, "Info", null);
        if (this.alignment > 0) {
            struct.add((DataType)new ArrayDataType(BYTE, this.alignment, BYTE.getLength()), "Padding", null);
        }
        struct.add(DWORD, "Signature", null);
        struct.add((DataType)new ArrayDataType(WORD, 2, WORD.getLength()), "StructVersion", null);
        struct.add((DataType)new ArrayDataType(WORD, 4, WORD.getLength()), "FileVersion", null);
        struct.add((DataType)new ArrayDataType(WORD, 4, WORD.getLength()), "ProductVersion", null);
        struct.add((DataType)new ArrayDataType(DWORD, 2, DWORD.getLength()), "FileFlagsMask", null);
        struct.add(DWORD, "FileFlags", null);
        struct.add(DWORD, "FileOS", null);
        struct.add(DWORD, "FileType", null);
        struct.add(DWORD, "FileSubtype", null);
        struct.add(DWORD, "FileTimestamp", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public VS_VERSION_CHILD[] getChildren() {
        VS_VERSION_CHILD[] arr = new VS_VERSION_CHILD[this.children.size()];
        this.children.toArray(arr);
        return arr;
    }

    public int getFileFlags() {
        return this.fileFlags;
    }

    public String getFileFlagsMask() {
        return this.fileFlagsMask;
    }

    public int getFileOS() {
        return this.fileOS;
    }

    public int getFileSubtype() {
        return this.fileSubtype;
    }

    public int getFileTimestamp() {
        return this.fileTimestamp;
    }

    public int getFileType() {
        return this.fileType;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public String getInfo() {
        return this.info;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public int getSignature() {
        return this.signature;
    }

    public short getStructLength() {
        return this.structLength;
    }

    public short getStructType() {
        return this.structType;
    }

    public String getStructVersion() {
        return this.structVersion;
    }

    public short getValueLength() {
        return this.valueLength;
    }

    public String[] getKeys() {
        Object[] keys = new String[this.valueMap.size()];
        Iterator<String> iter = this.valueMap.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            keys[i++] = iter.next();
        }
        Arrays.sort(keys);
        return keys;
    }

    public String getValue(String key) {
        return this.valueMap.get(key);
    }

    static String shortArrayToString(BinaryReader reader, int nElements) throws IOException {
        if (nElements == 2) {
            short[] arr = reader.readNextShortArray(2);
            return arr[1] + "." + arr[0];
        }
        if (nElements == 4) {
            short[] arr = reader.readNextShortArray(4);
            return arr[1] + "." + arr[0] + "." + arr[3] + "." + arr[2];
        }
        return null;
    }

    static String intArrayToString(BinaryReader reader, int nElements) throws IOException {
        if (nElements == 2) {
            int[] arr = reader.readNextIntArray(2);
            return arr[1] + "." + arr[0];
        }
        if (nElements == 4) {
            int[] arr = reader.readNextIntArray(4);
            return arr[1] + "." + arr[0] + "." + arr[3] + "." + arr[2];
        }
        return null;
    }
}

