/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.chained;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DyldChainedStartsInSegment
implements StructConverter {
    private int size;
    private short pageSize;
    private short pointerFormat;
    private long segmentOffset;
    private int maxValidPointer;
    private short pageCount;
    private short[] pageStarts;

    public DyldChainedStartsInSegment(BinaryReader reader) throws IOException {
        this.size = reader.readNextInt();
        this.pageSize = reader.readNextShort();
        this.pointerFormat = reader.readNextShort();
        this.segmentOffset = reader.readNextLong();
        this.maxValidPointer = reader.readNextInt();
        this.pageCount = reader.readNextShort();
        this.pageStarts = reader.readNextShortArray(this.pageCount);
    }

    public void markup(Program program, Address address, MachHeader header, TaskMonitor monitor, MessageLog log) throws CancelledException {
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_chained_starts_in_segment", 0);
        struct.add(DWORD, "size", "size of this (amount kernel needs to copy)");
        struct.add(WORD, "page_size", "0x1000 or 0x4000");
        struct.add(WORD, "pointer_format", "DYLD_CHAINED_PTR_*");
        struct.add(IBO64, "segment_offset", "offset in memory to start of segment");
        struct.add(DWORD, "max_valid_pointer", "for 32-bit OS, any value beyond this is not a pointer");
        struct.add(WORD, "page_count", "how many pages are in array");
        struct.add((DataType)new ArrayDataType(WORD, (int)this.pageCount, 1), "page_starts", "each entry is offset in each page of first element in chain or DYLD_CHAINED_PTR_START_NONE if no fixups on page");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public int getSize() {
        return this.size;
    }

    public short getPageSize() {
        return this.pageSize;
    }

    public short getPointerFormat() {
        return this.pointerFormat;
    }

    public long getSegmentOffset() {
        return this.segmentOffset;
    }

    public int getMaxValidPointer() {
        return this.maxValidPointer;
    }

    public short getPageCount() {
        return this.pageCount;
    }

    public short[] getPageStarts() {
        return this.pageStarts;
    }
}

