/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.widgets.table.GTableCellRenderingData;
import ghidra.app.plugin.core.function.tags.FunctionTagRowObject;
import ghidra.app.plugin.core.function.tags.FunctionTagTableModel;
import ghidra.program.model.listing.Function;
import ghidra.util.HTMLUtilities;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableCellRenderer;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class FunctionTagTable
extends GhidraTable {
    private boolean disable = false;
    private Function function = null;
    private TagRenderer renderer = new TagRenderer();

    public FunctionTagTable(FunctionTagTableModel model) {
        super((TableModel)((Object)model));
    }

    protected void setDisabled(boolean disable) {
        this.disable = disable;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public String getToolTipText(MouseEvent evt) {
        FunctionTagTable table = (FunctionTagTable)((Object)evt.getSource());
        int row = this.rowAtPoint(evt.getPoint());
        FunctionTagTableModel model = (FunctionTagTableModel)((Object)table.getModel());
        FunctionTagRowObject rowObject = (FunctionTagRowObject)model.getRowObject(row);
        String comment = rowObject.getComment();
        if (comment.isEmpty()) {
            return "no tooltip set";
        }
        return "<html>" + HTMLUtilities.escapeHTML((String)comment);
    }

    public TableCellRenderer getCellRenderer(int row, int col) {
        return this.renderer;
    }

    private class TagRenderer
    extends GhidraTableCellRenderer {
        private TagRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Component c = super.getTableCellRendererComponent(data);
            JTable table = data.getTable();
            int nameColumn = table.getColumnModel().getColumnIndex("Name");
            int row = data.getRowViewIndex();
            FunctionTagTableModel model = (FunctionTagTableModel)((Object)table.getModel());
            FunctionTagRowObject rowObject = (FunctionTagRowObject)model.getRowObject(row);
            boolean enableRow = true;
            if (FunctionTagTable.this.disable && FunctionTagTable.this.function != null) {
                String tagName = rowObject.getName();
                Set tags = FunctionTagTable.this.function.getTags();
                enableRow = !tags.stream().anyMatch(t -> t.getName().equals(tagName));
            }
            c.setEnabled(enableRow);
            int column = data.getColumnViewIndex();
            if (column == nameColumn && rowObject.isImmutable()) {
                this.setItalic();
            }
            return c;
        }
    }
}

