/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.ColorValue;
import generic.theme.FontValue;
import generic.theme.GThemeValueMap;
import generic.theme.IconValue;
import generic.theme.LafType;
import generic.theme.ThemeReader;
import generic.theme.ThemeWriter;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.swing.Icon;

public class GTheme
extends GThemeValueMap {
    public static final String FILE_PREFIX = "File:";
    public static final String JAVA_ICON = "<JAVA ICON>";
    public static String FILE_EXTENSION = "theme";
    public static String ZIP_FILE_EXTENSION = "theme.zip";
    private final String name;
    private final LafType lookAndFeel;
    private final boolean useDarkDefaults;
    private final File file;

    public GTheme(String name) {
        this(name, LafType.getDefaultLookAndFeel());
    }

    public GTheme(String name, LafType lafType) {
        this(null, name, lafType, lafType.usesDarkDefaults());
    }

    public GTheme(File file, String name, LafType lafType, boolean useDarkDefaults) {
        this.name = name;
        this.lookAndFeel = lafType;
        this.useDarkDefaults = useDarkDefaults;
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public LafType getLookAndFeelType() {
        return this.lookAndFeel;
    }

    public boolean useDarkDefaults() {
        return this.useDarkDefaults;
    }

    public String getThemeLocater() {
        if (this.file != null) {
            return FILE_PREFIX + this.file.getAbsolutePath();
        }
        return "Default";
    }

    public File getFile() {
        return this.file;
    }

    public void setColor(String id, Color color) {
        this.addColor(new ColorValue(id, color));
    }

    public void setColorRef(String id, String refId) {
        this.addColor(new ColorValue(id, refId));
    }

    public void setFont(String id, Font font) {
        this.addFont(new FontValue(id, font));
    }

    public void setFontRef(String id, String refId) {
        this.addFont(new FontValue(id, refId));
    }

    public void setIcon(String id, Icon icon) {
        this.addIcon(new IconValue(id, icon));
    }

    public void setIconRef(String id, String refId) {
        this.addIcon(new IconValue(id, refId));
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTheme other = (GTheme)obj;
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.lookAndFeel, (Object)other.lookAndFeel);
    }

    public boolean hasSupportedLookAndFeel() {
        return this.lookAndFeel.isSupported();
    }

    public void save() throws IOException {
        ThemeWriter writer = new ThemeWriter(this);
        writer.writeThemeToFile(this.file);
    }

    public boolean isReadOnly() {
        return false;
    }

    public static GTheme loadTheme(File file) throws IOException {
        ThemeReader reader = new ThemeReader(file);
        return reader.readTheme();
    }
}

