/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.BinaryCodedField;
import db.BinaryField;
import db.DBBuffer;
import db.DBRecord;
import ghidra.program.database.mem.FileBytesAdapter;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import org.apache.commons.lang3.StringUtils;

public class FileBytes {
    final FileBytesAdapter adapter;
    private final long id;
    private final String filename;
    private final long fileOffset;
    private final long size;
    private DBBuffer[] originalBuffers;
    private DBBuffer[] layeredBuffers;
    private boolean invalid = false;

    public FileBytes(FileBytesAdapter adapter, DBRecord record) throws IOException {
        this.adapter = adapter;
        this.id = record.getKey();
        this.filename = record.getString(0);
        this.fileOffset = record.getLongValue(1);
        this.size = record.getLongValue(2);
        this.refresh(record);
    }

    synchronized boolean refresh(DBRecord record) throws IOException {
        int i;
        String f = record.getString(0);
        long offset = record.getLongValue(1);
        long sz = record.getLongValue(2);
        if (offset != this.fileOffset || sz != this.size || !StringUtils.equals((CharSequence)f, (CharSequence)this.filename)) {
            return false;
        }
        BinaryField field = (BinaryField)record.getFieldValue(3);
        int[] bufferIds = new BinaryCodedField(field).getIntArray();
        this.originalBuffers = new DBBuffer[bufferIds.length];
        for (i = 0; i < bufferIds.length; ++i) {
            this.originalBuffers[i] = this.adapter.getBuffer(bufferIds[i]);
        }
        field = (BinaryField)record.getFieldValue(4);
        bufferIds = new BinaryCodedField(field).getIntArray();
        this.layeredBuffers = new DBBuffer[bufferIds.length];
        for (i = 0; i < bufferIds.length; ++i) {
            this.layeredBuffers[i] = this.adapter.getBuffer(bufferIds[i], this.originalBuffers[i]);
        }
        return true;
    }

    long getId() {
        return this.id;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public long getSize() {
        return this.size;
    }

    public synchronized byte getModifiedByte(long offset) throws IOException, IndexOutOfBoundsException {
        return this.getByte(this.layeredBuffers, offset);
    }

    public synchronized byte getOriginalByte(long offset) throws IOException, IndexOutOfBoundsException {
        return this.getByte(this.originalBuffers, offset);
    }

    public synchronized int getModifiedBytes(long offset, byte[] b) throws IOException, IndexOutOfBoundsException {
        return this.getBytes(this.layeredBuffers, offset, b, 0, b.length);
    }

    public synchronized int getOriginalBytes(long offset, byte[] b) throws IOException, IndexOutOfBoundsException {
        return this.getBytes(this.originalBuffers, offset, b, 0, b.length);
    }

    public synchronized int getModifiedBytes(long offset, byte[] b, int off, int length) throws IOException, IndexOutOfBoundsException {
        return this.getBytes(this.layeredBuffers, offset, b, off, length);
    }

    public synchronized int getOriginalBytes(long offset, byte[] b, int off, int length) throws IOException, IndexOutOfBoundsException {
        return this.getBytes(this.originalBuffers, offset, b, off, length);
    }

    void checkValid() {
        if (this.invalid) {
            throw new ConcurrentModificationException();
        }
    }

    synchronized void invalidate() {
        this.invalid = true;
    }

    synchronized void putByte(long offset, byte b) throws IndexOutOfBoundsException, IOException {
        this.checkValid();
        if (offset < 0L || offset >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int maxBufferSize = this.layeredBuffers[0].length();
        int dbBufferIndex = (int)(offset / (long)maxBufferSize);
        int localOffset = (int)(offset % (long)maxBufferSize);
        this.layeredBuffers[dbBufferIndex].putByte(localOffset, b);
    }

    synchronized int putBytes(long offset, byte[] b) throws IOException, IndexOutOfBoundsException {
        return this.putBytes(offset, b, 0, b.length);
    }

    synchronized int putBytes(long offset, byte[] b, int off, int length) throws IOException, IndexOutOfBoundsException {
        this.checkValid();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || length < 0 || length > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        if ((length = (int)Math.min((long)length, this.size - offset)) == 0) {
            return 0;
        }
        int maxBufferSize = this.layeredBuffers[0].length();
        long fileBytesOffset = offset;
        int byteArrayOffset = off;
        int n = length;
        while (n > 0) {
            int dbBufferIndex = (int)(fileBytesOffset / (long)maxBufferSize);
            int localOffset = (int)(fileBytesOffset % (long)maxBufferSize);
            int writeLen = Math.min(maxBufferSize - localOffset, n);
            this.layeredBuffers[dbBufferIndex].put(localOffset, b, byteArrayOffset, writeLen);
            n -= writeLen;
            fileBytesOffset += (long)writeLen;
            byteArrayOffset += writeLen;
        }
        return length;
    }

    private byte getByte(DBBuffer[] buffers, long offset) throws IndexOutOfBoundsException, IOException {
        this.checkValid();
        if (offset < 0L || offset >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        int maxBufferSize = buffers[0].length();
        int dbBufferIndex = (int)(offset / (long)maxBufferSize);
        int localOffset = (int)(offset % (long)maxBufferSize);
        return buffers[dbBufferIndex].getByte(localOffset);
    }

    private int getBytes(DBBuffer[] buffers, long offset, byte[] b, int off, int length) throws IndexOutOfBoundsException, IOException {
        this.checkValid();
        if (off < 0 || length < 0 || length > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        if ((length = (int)Math.min((long)length, this.size - offset)) == 0) {
            return 0;
        }
        int maxBufferSize = buffers[0].length();
        long fileBytesOffset = offset;
        int byteArrayOffset = off;
        int n = length;
        while (n > 0) {
            int dbBufferIndex = (int)(fileBytesOffset / (long)maxBufferSize);
            int localOffset = (int)(fileBytesOffset % (long)maxBufferSize);
            int readLen = Math.min(maxBufferSize - localOffset, n);
            buffers[dbBufferIndex].get(localOffset, b, byteArrayOffset, readLen);
            n -= readLen;
            fileBytesOffset += (long)readLen;
            byteArrayOffset += readLen;
        }
        return length;
    }

    public String toString() {
        return this.getFilename();
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileBytes other = (FileBytes)obj;
        if (this.adapter != other.adapter) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        return this.invalid == other.invalid;
    }
}

