/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.flowchart;

import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.ColSegmentList;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.ColumnSegment;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.EdgeSegment;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.RowSegment;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.RowSegmentList;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.GridPoint;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EdgeSegmentMap<E> {
    private Map<Integer, RowSegmentList<E>> rowSegmentMap = new HashMap<Integer, RowSegmentList<E>>();
    private Map<Integer, ColSegmentList<E>> colSegmentMap = new HashMap<Integer, ColSegmentList<E>>();

    public EdgeSegmentMap(GridLocationMap<?, E> grid) {
        this.createEdgeSegments(grid);
        this.assignEdgeSegmentOffsets();
    }

    public Collection<RowSegmentList<E>> rowSegments() {
        return this.rowSegmentMap.values();
    }

    public Collection<ColSegmentList<E>> colSegments() {
        return this.colSegmentMap.values();
    }

    public ColumnSegment<E> getColumnSegment(E edge, GridPoint gridPoint) {
        ColSegmentList<E> colSegments = this.colSegmentMap.get(gridPoint.col);
        return colSegments == null ? null : colSegments.getSegment(edge, gridPoint);
    }

    public void dispose() {
        this.rowSegmentMap.clear();
        this.colSegmentMap.clear();
    }

    private void createEdgeSegments(GridLocationMap<?, E> grid) {
        for (Object edge : grid.edges()) {
            List gridPoints = grid.getArticulations(edge);
            EdgeSegment colSegment = new ColumnSegment(edge, gridPoints);
            this.addColSegment((ColumnSegment<E>)colSegment);
            while (!colSegment.isEndSegment()) {
                EdgeSegment rowSegment = colSegment.nextSegment();
                this.addRowSegment((RowSegment<E>)rowSegment);
                colSegment = ((RowSegment)rowSegment).nextSegment();
                this.addColSegment((ColumnSegment<E>)colSegment);
            }
        }
    }

    private void assignEdgeSegmentOffsets() {
        for (RowSegmentList<E> rowSegmentList : this.rowSegmentMap.values()) {
            rowSegmentList.assignOffsets();
        }
        for (ColSegmentList colSegmentList : this.colSegmentMap.values()) {
            colSegmentList.assignOffsets();
        }
    }

    private void addRowSegment(RowSegment<E> rowSegment) {
        int row = rowSegment.getRow();
        RowSegmentList edgeRow = this.rowSegmentMap.computeIfAbsent(row, k -> new RowSegmentList((int)k));
        edgeRow.addSegment(rowSegment);
    }

    private void addColSegment(ColumnSegment<E> colSegment) {
        int col = colSegment.getCol();
        ColSegmentList edgeCol = this.colSegmentMap.computeIfAbsent(col, k -> new ColSegmentList((int)k));
        edgeCol.addSegment(colSegment);
    }
}

