/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.xml;

import android.content.res.AXmlResourceParser;
import ghidra.util.StringUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

public class AndroidXmlConvertor {
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.051758E-5f, 1.192093E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNITS = new String[]{"px", "dip", "sp", "pt", "in", "mm", "", ""};
    private static final String[] FRACTION_UNITS = new String[]{"%", "%p", "", "", "", "", "", ""};
    public static final byte[] ANDROID_BINARY_XML_MAGIC = new byte[]{3, 0, 8, 0};
    public static final int ANDROID_BINARY_XML_MAGIC_LEN = 4;

    public static void convert(InputStream is, PrintWriter out, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Converting Android Binary XML to Text...");
        parser.open(is);
        try (AXmlResourceParser parser = new AXmlResourceParser();){
            int type;
            int indent = -1;
            while ((type = parser.next()) != 1) {
                monitor.checkCancelled();
                StringBuffer buffer = new StringBuffer();
                switch (type) {
                    case 0: {
                        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                        buffer.append("\n");
                        break;
                    }
                    case 2: {
                        int i;
                        buffer.append(StringUtilities.pad((String)"", (char)'\t', (int)(++indent)));
                        buffer.append("<");
                        buffer.append(AndroidXmlConvertor.getNamespacePrefix(parser.getPrefix()));
                        buffer.append(parser.getName());
                        buffer.append("\n");
                        int namespaceCountBefore = parser.getNamespaceCount(parser.getDepth() - 1);
                        int namespaceCount = parser.getNamespaceCount(parser.getDepth());
                        ++indent;
                        for (i = namespaceCountBefore; i != namespaceCount; ++i) {
                            buffer.append(StringUtilities.pad((String)"", (char)'\t', (int)indent));
                            buffer.append("xmlns:");
                            buffer.append(parser.getNamespacePrefix(i));
                            buffer.append("=");
                            buffer.append("\"");
                            buffer.append(parser.getNamespaceUri(i));
                            buffer.append("\"");
                            buffer.append("\n");
                        }
                        for (i = 0; i < parser.getAttributeCount(); ++i) {
                            buffer.append(StringUtilities.pad((String)"", (char)'\t', (int)indent));
                            buffer.append(AndroidXmlConvertor.getNamespacePrefix(parser.getAttributePrefix(i)));
                            buffer.append(parser.getAttributeName(i));
                            buffer.append("=");
                            buffer.append("\"");
                            buffer.append(AndroidXmlConvertor.getAttributeValue(parser, i));
                            buffer.append("\"");
                            buffer.append("\n");
                        }
                        buffer.append(StringUtilities.pad((String)"", (char)'\t', (int)indent));
                        buffer.append(">");
                        buffer.append("\n");
                        --indent;
                        break;
                    }
                    case 3: {
                        buffer.append(StringUtilities.pad((String)"", (char)'\t', (int)indent));
                        buffer.append("<");
                        buffer.append("/");
                        buffer.append(AndroidXmlConvertor.getNamespacePrefix(parser.getPrefix()));
                        buffer.append(parser.getName());
                        buffer.append(">");
                        buffer.append("\n");
                        --indent;
                        break;
                    }
                    case 4: {
                        buffer.append(StringUtilities.pad((String)"", (char)'\t', (int)indent));
                        buffer.append(parser.getText());
                        buffer.append("\n");
                    }
                }
                out.print(buffer.toString());
            }
            out.println();
        }
    }

    private static String getNamespacePrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return "";
        }
        return prefix + ":";
    }

    private static String getAttributeValue(AXmlResourceParser parser, int index) {
        int type = parser.getAttributeValueType(index);
        int data = parser.getAttributeValueData(index);
        if (type == 3) {
            return parser.getAttributeValue(index);
        }
        if (type == 2) {
            return String.format("?%s%08X", AndroidXmlConvertor.getPackage(data), data);
        }
        if (type == 1) {
            return String.format("@%s%08X", AndroidXmlConvertor.getPackage(data), data);
        }
        if (type == 4) {
            return String.valueOf(Float.intBitsToFloat(data));
        }
        if (type == 17) {
            return String.format("0x%08X", data);
        }
        if (type == 18) {
            return data == 0 ? "false" : "true";
        }
        if (type == 5) {
            return Float.toString(AndroidXmlConvertor.complexToFloat(data)) + DIMENSION_UNITS[data & 0xF];
        }
        if (type == 6) {
            return Float.toString(AndroidXmlConvertor.complexToFloat(data)) + FRACTION_UNITS[data & 0xF];
        }
        if (type >= 28 && type <= 31) {
            return String.format("#%08X", data);
        }
        if (type >= 16 && type <= 31) {
            return String.valueOf(data);
        }
        return String.format("<0x%X, type 0x%02X>", data, type);
    }

    private static String getPackage(int id) {
        if (id >>> 24 == 1) {
            return "android:";
        }
        return "";
    }

    private static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }
}

