/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class ImageFunctionEntry {
    private long startingAddress;
    private long endingAddress;
    private long endOfPrologueAddress;

    public long getStartingAddress() {
        return this.startingAddress;
    }

    public long getEndingAddress() {
        return this.endingAddress;
    }

    public long getEndOfPrologueAddress() {
        return this.endOfPrologueAddress;
    }

    public void deserialize(PdbByteReader reader) throws PdbException {
        this.startingAddress = reader.parseUnsignedIntVal();
        this.endingAddress = reader.parseUnsignedIntVal();
        this.endOfPrologueAddress = reader.parseUnsignedIntVal();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.dump(writer);
            return writer.toString();
        }
        catch (IOException e) {
            return "Issue in " + this.getClass().getSimpleName() + " toString(): " + e.getMessage();
        }
    }

    void dump(Writer writer) throws IOException {
        PdbReaderUtils.dumpHead(writer, this);
        writer.write(String.format("startingAddress: 0X%08X\n", this.startingAddress));
        writer.write(String.format("endingAddress: 0X%08X\n", this.endingAddress));
        writer.write(String.format("endOfPrologueAddress: 0X%08X\n", this.endOfPrologueAddress));
        PdbReaderUtils.dumpTail(writer, this);
    }
}

