/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.plugintool.GenericStandAloneApplication;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;

public class StandAlonePluginTool
extends PluginTool {
    private DockingAction configureToolAction;
    private final GenericStandAloneApplication app;
    private final String name;

    public StandAlonePluginTool(GenericStandAloneApplication app, String name, boolean hasStatus) {
        super(null, null, app.getToolServices(), name, true, hasStatus, false);
        this.app = app;
        this.name = name;
    }

    @Override
    public void addExitAction() {
        DockingAction exitAction = new DockingAction("Exit", "Tool"){

            public void actionPerformed(ActionContext context) {
                StandAlonePluginTool.this.app.exit();
            }
        };
        exitAction.setHelpLocation(new HelpLocation("FrontEndPlugin", exitAction.getName()));
        exitAction.setMenuBarData(new MenuData(new String[]{"&File", "E&xit " + this.name}, null, "Window_Z"));
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.MAC_OS_X) {
            exitAction.setKeyBindingData(new KeyBindingData(81, 128));
        }
        exitAction.setEnabled(true);
        this.addAction((DockingActionIf)exitAction);
    }

    @Override
    public void addExportToolAction() {
        super.addExportToolAction();
    }

    @Override
    public void addSaveToolAction() {
        super.addSaveToolAction();
    }

    public void addManagePluginsAction() {
        this.configureToolAction = new DockingAction("Configure Tool", "Tool"){

            public void actionPerformed(ActionContext context) {
                StandAlonePluginTool.this.showConfig(false, false);
            }
        };
        this.configureToolAction.setMenuBarData(new MenuData(new String[]{"&File", "Configure..."}, null, "PrintPost_PreTool"));
        this.configureToolAction.setEnabled(true);
        this.addAction((DockingActionIf)this.configureToolAction);
    }
}

