/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class AsciiFormatModel
implements UniversalDataFormatModel {
    private int symbolSize = 1;

    @Override
    public String getName() {
        return "Ascii";
    }

    @Override
    public int getUnitByteSize() {
        return 1;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        return 0;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        return 0;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        byte b = block.getByte(index);
        String str = null;
        if (b < 32 || b == 127) {
            str = ".";
        } else {
            char[] charArray = new char[]{(char)b};
            str = new String(charArray);
        }
        return str;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean replaceValue(ByteBlock block, BigInteger index, int charPosition, char c) throws ByteBlockAccessException {
        if (charPosition != 0) {
            return false;
        }
        block.getByte(index);
        byte cb = (byte)c;
        if (cb < 32 || cb == 127) {
            return false;
        }
        block.setByte(index, cb);
        return true;
    }

    @Override
    public int getGroupSize() {
        return 0;
    }

    @Override
    public void setGroupSize(int groupSize) {
        throw new UnsupportedOperationException("groups are not supported");
    }

    @Override
    public int getUnitDelimiterSize() {
        return 0;
    }

    @Override
    public boolean validateBytesPerLine(int bytesPerLine) {
        return true;
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "Ascii");
    }

    @Override
    public void dispose() {
    }

    public boolean supportsProvider(ByteViewerComponentProvider provider) {
        return true;
    }
}

