/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.fbpk;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.android.fbpk.FBPT_Entry;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public abstract class FBPT
implements StructConverter {
    public abstract String getMagic();

    public abstract List<FBPT_Entry> getEntries();

    public void processFBPT(Program program, Address address, TaskMonitor monitor, MessageLog log) throws Exception {
        FlatProgramAPI api = new FlatProgramAPI(program);
        DataType fbptDataType = this.toDataType();
        Data fbptData = program.getListing().createData(address, fbptDataType);
        if (fbptData == null) {
            log.appendMsg("Unable to apply FBPT data, stopping - " + String.valueOf(address));
            return;
        }
        String comment = "FBPT\nNum of entries: " + this.getEntries().size();
        program.getListing().setComment(address, CommentType.PLATE, comment);
        api.createFragment("FBPT", address, (long)fbptDataType.getLength());
        address = address.add((long)fbptDataType.getLength());
        this.processFbPtEntries(program, address, monitor, log);
    }

    private void processFbPtEntries(Program program, Address address, TaskMonitor monitor, MessageLog log) throws Exception {
        int i = 0;
        FlatProgramAPI api = new FlatProgramAPI(program);
        for (FBPT_Entry entry : this.getEntries()) {
            monitor.checkCancelled();
            DataType entryDataType = entry.toDataType();
            Data entryData = program.getListing().createData(address, entryDataType);
            if (entryData == null) {
                log.appendMsg("Unable to apply FBPT Entry data, stopping - " + String.valueOf(address));
                return;
            }
            program.getListing().setComment(address, CommentType.PLATE, entry.getName() + " - " + i++);
            api.createFragment("FBPT", address, (long)entryDataType.getLength());
            address = address.add((long)entryDataType.getLength());
        }
    }
}

