/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import docking.widgets.table.GTableFilterPanel;
import ghidra.debug.api.breakpoint.LogicalBreakpoint;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.table.TableCellEditor;

public abstract class DebuggerBreakpointStateTableCellEditor<T>
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private final GTableFilterPanel<T> filterPanel;
    protected final JButton button = new JButton();
    private LogicalBreakpoint.State value = LogicalBreakpoint.State.NONE;
    private T row;

    public DebuggerBreakpointStateTableCellEditor(GTableFilterPanel<T> filterPanel) {
        this.filterPanel = filterPanel;
        this.button.setHorizontalAlignment(0);
        this.button.setOpaque(true);
        this.button.setBorder(BorderFactory.createEmptyBorder());
        this.button.setUI(new BasicButtonUI());
        this.button.addActionListener(this);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setBackground(table.getBackground());
        }
        this.row = this.filterPanel.getRowObject(row);
        this.value = (LogicalBreakpoint.State)value;
        this.button.setIcon(this.value.icon);
        this.button.setHorizontalAlignment(0);
        return this.button;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.value = this.getToggledState(this.row, this.value);
        this.fireEditingStopped();
    }

    protected abstract LogicalBreakpoint.State getToggledState(T var1, LogicalBreakpoint.State var2);
}

