/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen;

import ghidra.pcode.emu.jit.gen.GenConsts;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.StaticFieldReq;
import ghidra.program.model.lang.RegisterValue;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

record FieldForContext(RegisterValue ctx) implements StaticFieldReq
{
    @Override
    public String name() {
        return "CTX_%s".formatted(this.ctx.getUnsignedValue().toString(16));
    }

    @Override
    public void generateClinitCode(JitCodeGenerator gen, ClassVisitor cv, MethodVisitor sv) {
        if (this.ctx == null) {
            return;
        }
        cv.visitField(26, this.name(), GenConsts.TDESC_REGISTER_VALUE, null, null);
        sv.visitFieldInsn(178, gen.nameThis, "LANGUAGE", GenConsts.TDESC_LANGUAGE);
        sv.visitLdcInsn((Object)this.ctx.getUnsignedValue().toString(16));
        sv.visitMethodInsn(184, GenConsts.NAME_JIT_COMPILED_PASSAGE, "createContext", GenConsts.MDESC_JIT_COMPILED_PASSAGE__CREATE_CONTEXT, true);
        sv.visitFieldInsn(179, gen.nameThis, this.name(), GenConsts.TDESC_REGISTER_VALUE);
    }

    @Override
    public void generateLoadCode(JitCodeGenerator gen, MethodVisitor rv) {
        if (this.ctx == null) {
            rv.visitInsn(1);
        } else {
            rv.visitFieldInsn(178, gen.nameThis, this.name(), GenConsts.TDESC_REGISTER_VALUE);
        }
    }
}

