/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcode.utils.SlaFormat;
import ghidra.pcodeCPort.slghpatexpress.PatternValue;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.program.model.pcode.Encoder;
import ghidra.sleigh.grammar.Location;
import java.io.IOException;

public class ContextField
extends PatternValue {
    private int startbit;
    private int endbit;
    private int startbyte;
    private int endbyte;
    private int shift;
    private boolean signbit;

    public ContextField(Location location) {
        super(location);
    }

    public int getStartBit() {
        return this.startbit;
    }

    public int getEndBit() {
        return this.endbit;
    }

    public boolean getSignBit() {
        return this.signbit;
    }

    @Override
    public TokenPattern genMinPattern(VectorSTL<TokenPattern> ops) {
        return new TokenPattern(this.location);
    }

    @Override
    public long minValue() {
        return 0L;
    }

    @Override
    public long maxValue() {
        long res = 0L;
        res ^= 0xFFFFFFFFFFFFFFFFL;
        res = Utils.zzz_zero_extend(res, this.endbit - this.startbit);
        return res;
    }

    public ContextField(Location location, boolean s, int sbit, int ebit) {
        super(location);
        this.signbit = s;
        this.startbit = sbit;
        this.endbit = ebit;
        this.startbyte = this.startbit / 8;
        this.endbyte = this.endbit / 8;
        this.shift = 7 - this.endbit % 8;
    }

    public String toString() {
        return "cf:{" + this.startbit + "," + this.endbit + "," + this.startbyte + "," + this.endbyte + "," + this.shift + "," + this.signbit + "}";
    }

    @Override
    public TokenPattern genPattern(long val) {
        return new TokenPattern(this.location, val, this.startbit, this.endbit);
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(SlaFormat.ELEM_CONTEXTFIELD);
        encoder.writeBool(SlaFormat.ATTRIB_SIGNBIT, this.signbit);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_STARTBIT, this.startbit);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_ENDBIT, this.endbit);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_STARTBYTE, this.startbyte);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_ENDBYTE, this.endbyte);
        encoder.writeSignedInteger(SlaFormat.ATTRIB_SHIFT, this.shift);
        encoder.closeElement(SlaFormat.ELEM_CONTEXTFIELD);
    }
}

