/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.layout.flowchart;

import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.OrthogonalEdgeRouter;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.OrthogonalGridToLayoutMapper;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.VisualGraph;
import ghidra.graph.graphs.DefaultVisualGraph;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.AbstractVisualGraphLayout;
import ghidra.graph.viewer.layout.Column;
import ghidra.graph.viewer.layout.GridLocationMap;
import ghidra.graph.viewer.layout.GridRange;
import ghidra.graph.viewer.layout.LayoutPositions;
import ghidra.graph.viewer.layout.Row;
import ghidra.graph.viewer.vertex.VisualGraphVertexShapeTransformer;
import ghidra.util.exception.CancelledException;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class AbstractFlowChartLayout<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractVisualGraphLayout<V, E> {
    protected Comparator<E> edgeComparator;
    protected boolean leftAligned;

    protected AbstractFlowChartLayout(DefaultVisualGraph<V, E> graph, Comparator<E> edgeComparator, boolean leftAligned) {
        super(graph, "Flow Chart");
        this.edgeComparator = edgeComparator;
        this.leftAligned = leftAligned;
    }

    protected GridLocationMap<V, E> performInitialGridLayout(VisualGraph<V, E> g) throws CancelledException {
        V root = this.getRoot(g);
        GDirectedGraph tree = GraphAlgorithms.toTree(g, root, this.edgeComparator);
        GridLocationMap<V, E> grid = this.computeGridLocationMap((GDirectedGraph<V, E>)g, (GDirectedGraph<V, E>)tree, root);
        OrthogonalEdgeRouter<V, VisualEdge> router = new OrthogonalEdgeRouter<V, VisualEdge>(grid);
        router.setColumnExclusionFunction(e -> this.getExcludedCols(grid, tree, e));
        router.computeAndSetEdgeArticulations(g.getEdges());
        return grid;
    }

    protected LayoutPositions<V, E> positionInLayoutSpaceFromGrid(VisualGraph<V, E> g, GridLocationMap<V, E> grid) throws CancelledException {
        boolean isCondensed = this.isCondensedLayout();
        VisualGraphVertexShapeTransformer transformer = new VisualGraphVertexShapeTransformer();
        OrthogonalGridToLayoutMapper<V, E> layoutMap = new OrthogonalGridToLayoutMapper<V, E>(grid, transformer, isCondensed);
        Map<V, Point2D> vertexMap = layoutMap.getVertexLocations();
        Map<E, List<Point2D>> edgeMap = layoutMap.getEdgeLocations(vertexMap);
        LayoutPositions positions = LayoutPositions.createNewPositions(vertexMap, edgeMap);
        layoutMap.dispose();
        return positions;
    }

    protected abstract V getRoot(VisualGraph<V, E> var1);

    public boolean usesEdgeArticulations() {
        return true;
    }

    protected Point2D getVertexLocation(V v, Column<V> col, Row<V> row, Rectangle bounds) {
        return this.getCenteredVertexLocation((VisualVertex)v, (Column)col, (Row)row, bounds);
    }

    private GridLocationMap<V, E> computeGridLocationMap(GDirectedGraph<V, E> g, GDirectedGraph<V, E> tree, V v) {
        int leftChildRootCol;
        Collection edges = tree.getOutEdges(v);
        if (edges.isEmpty()) {
            GridLocationMap grid = new GridLocationMap(v, 1, 1);
            return grid;
        }
        ArrayList<E> sortedEdges = new ArrayList<E>(edges);
        sortedEdges.sort(this.edgeComparator);
        VisualEdge edge = (VisualEdge)sortedEdges.get(0);
        VisualVertex child = (VisualVertex)edge.getEnd();
        int totalEdges = sortedEdges.size();
        GridLocationMap<VisualVertex, E> childGrid = this.computeGridLocationMap(g, tree, child);
        int rightChildRootCol = leftChildRootCol = childGrid.getRootColumn();
        for (int i = 1; i < totalEdges; ++i) {
            edge = (VisualEdge)sortedEdges.get(i);
            child = (VisualVertex)edge.getEnd();
            GridLocationMap<VisualVertex, E> nextGrid = this.computeGridLocationMap(g, tree, child);
            int shift = this.merge(childGrid, nextGrid, i, totalEdges);
            rightChildRootCol = nextGrid.getRootColumn() + shift;
        }
        int rootCol = (leftChildRootCol + rightChildRootCol) / 2;
        if (this.leftAligned) {
            rootCol = 1;
        }
        GridLocationMap grid = new GridLocationMap(v, 1, rootCol);
        grid.add(childGrid, 2, 0);
        return grid;
    }

    private int merge(GridLocationMap<V, E> leftGrid, GridLocationMap<V, E> rightGrid, int i, int totalEdges) {
        GridRange[] ranges = leftGrid.getVertexColumnRanges();
        GridRange[] otherRanges = rightGrid.getVertexColumnRanges();
        int shift = this.computeShift(ranges, otherRanges);
        leftGrid.add(rightGrid, 0, shift);
        return shift;
    }

    private int computeShift(GridRange[] ranges, GridRange[] otherRanges) {
        int shift = 0;
        int commonHeight = Math.min(ranges.length, otherRanges.length);
        for (int i = 0; i < commonHeight; ++i) {
            GridRange range = ranges[i];
            GridRange otherRange = otherRanges[i];
            int myMax = range.max;
            int otherMin = otherRange.min;
            if (myMax < otherMin - 1) continue;
            int diff = myMax - otherMin + 2;
            shift = Math.max(shift, diff);
        }
        return shift;
    }

    public VisualGraph<V, E> getVisualGraph() {
        return (VisualGraph)this.getGraph();
    }

    private GridRange getExcludedCols(GridLocationMap<V, E> grid, GDirectedGraph<V, E> tree, E e) {
        boolean isBackEdge;
        GridRange range = new GridRange();
        VisualVertex v = (VisualVertex)e.getStart();
        VisualVertex ancestor = (VisualVertex)e.getEnd();
        boolean bl = isBackEdge = grid.row((Object)v) >= grid.row((Object)ancestor);
        if (!isBackEdge) {
            return new GridRange();
        }
        VisualVertex parent = this.getParent(tree, v);
        while (parent != null) {
            Collection children = tree.getSuccessors((Object)parent);
            for (VisualVertex child : children) {
                range.add(grid.col((Object)child));
            }
            if ((parent = this.getParent(tree, parent)) != ancestor) continue;
            break;
        }
        return range;
    }

    private V getParent(GDirectedGraph<V, E> tree, V v) {
        Collection predecessors = tree.getPredecessors(v);
        if (predecessors == null || predecessors.isEmpty()) {
            return null;
        }
        return (V)((VisualVertex)predecessors.iterator().next());
    }
}

