/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.label.GLabel;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.RowObjectTableModel;
import ghidra.bitpatterns.gui.ByteSequenceLengthFilterInputDialog;
import ghidra.bitpatterns.gui.ContextRegisterFilterablePanelBuilder;
import ghidra.bitpatterns.gui.DisassembledByteSequenceTableModel;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.info.ByteSequenceLengthFilter;
import ghidra.bitpatterns.info.ByteSequenceRowObject;
import ghidra.bitpatterns.info.FileBitPatternInfoReader;
import ghidra.bitpatterns.info.PatternType;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ByteSequencePanelBuilder
extends ContextRegisterFilterablePanelBuilder {
    private DisassembledByteSequenceTableModel byteSeqTable;
    private List<ByteSequenceRowObject> rowObjects;
    private FunctionBitPatternsExplorerPlugin plugin;
    private FileBitPatternInfoReader fsReader;
    private PatternType type;
    private static final int TABLE_INDEX = 1;
    private ByteSequenceLengthFilter lengthFilter;
    private JButton applyLengthFilterButton;
    private JButton clearLengthFilterButton;
    private JTextField numSeqsField;
    private GFilterTable<ByteSequenceRowObject> filterTable;
    private static final String APPLY_LENGTH_FILTER_BUTTON_TEXT = "Apply Length Filter";
    private static final String CLEAR_LENGTH_FILTER_BUTTON_TEXT = "Clear Length Filter";
    private static final String BYTE_SEQUENCE_LENGTH_FILTER_CREATER_TEXT = "Set Length Filter";
    private static final String NUM_SEQS_LABEL_TEXT = " Number of Sequences ";

    public ByteSequencePanelBuilder(FunctionBitPatternsExplorerPlugin plugin, PatternType type) {
        this.plugin = plugin;
        this.type = type;
    }

    public List<ByteSequenceRowObject> getLastSelectedRows() {
        return this.byteSeqTable.getLastSelectedObjects();
    }

    @Override
    public void applyFilterAction() {
        this.updateTable();
    }

    @Override
    public void clearFilterAction() {
        this.updateExtentAndClearFilter(this.fsReader.getContextRegisterExtent());
        this.updateTable();
    }

    public boolean isLengthFiltered() {
        return this.lengthFilter != null;
    }

    public ByteSequenceLengthFilter getLengthFilter() {
        return this.lengthFilter;
    }

    public PatternType getType() {
        return this.type;
    }

    public JPanel buildMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel numSeqsPanel = new JPanel();
        PairLayout numSeqsLayout = new PairLayout();
        numSeqsPanel.setLayout((LayoutManager)numSeqsLayout);
        numSeqsPanel.add((Component)new GLabel(NUM_SEQS_LABEL_TEXT));
        this.numSeqsField = new JTextField(25);
        this.numSeqsField.setEditable(false);
        numSeqsPanel.add(this.numSeqsField);
        this.mainPanel.add((Component)numSeqsPanel, "North");
        this.mainPanel.add((Component)this.getButtonPanel(), "South");
        this.byteSeqTable = new DisassembledByteSequenceTableModel(this.plugin, this.rowObjects);
        this.filterTable = new GFilterTable((RowObjectTableModel)this.byteSeqTable);
        this.mainPanel.add((Component)this.filterTable, "Center", 1);
        this.addLengthFilterAndAnalysisButtons();
        this.mainPanel.setVisible(true);
        return this.mainPanel;
    }

    public void updateTable() {
        this.mainPanel.remove(1);
        this.filterTable.dispose();
        this.rowObjects = ByteSequenceRowObject.getFilteredRowObjects(this.fsReader.getFInfoList(), this.type, this.getContextRegisterFilter(), this.lengthFilter);
        this.byteSeqTable = new DisassembledByteSequenceTableModel(this.plugin, this.rowObjects);
        this.filterTable = new GFilterTable((RowObjectTableModel)this.byteSeqTable);
        int totalNumSeqs = 0;
        for (ByteSequenceRowObject row : this.rowObjects) {
            totalNumSeqs += row.getNumOccurrences();
        }
        this.numSeqsField.setText(Integer.toString(totalNumSeqs));
        this.mainPanel.add((Component)this.filterTable, "Center", 1);
        this.mainPanel.updateUI();
    }

    public void setFsReader(FileBitPatternInfoReader fsReader) {
        this.fsReader = fsReader;
        this.updateExtentAndClearFilter(fsReader.getContextRegisterExtent());
        this.lengthFilter = null;
        this.updateTable();
    }

    private void addLengthFilterAndAnalysisButtons() {
        this.applyLengthFilterButton = new JButton(APPLY_LENGTH_FILTER_BUTTON_TEXT);
        this.getButtonPanel().add(this.applyLengthFilterButton);
        this.applyLengthFilterButton.addActionListener(e -> {
            ByteSequenceLengthFilterInputDialog filterCreator = new ByteSequenceLengthFilterInputDialog(BYTE_SEQUENCE_LENGTH_FILTER_CREATER_TEXT, this.mainPanel);
            if (filterCreator.isCanceled()) {
                return;
            }
            this.lengthFilter = filterCreator.getValue();
            this.applyFilterAction();
        });
        this.clearLengthFilterButton = new JButton(CLEAR_LENGTH_FILTER_BUTTON_TEXT);
        this.getButtonPanel().add(this.clearLengthFilterButton);
        this.clearLengthFilterButton.addActionListener(e -> {
            this.lengthFilter = null;
            this.updateTable();
        });
    }

    public void enableLengthFilterButtons(boolean enabled) {
        if (this.applyLengthFilterButton != null) {
            this.applyLengthFilterButton.setEnabled(enabled);
        }
        if (this.clearLengthFilterButton != null) {
            this.clearLengthFilterButton.setEnabled(enabled);
        }
    }

    public void dispose() {
        this.filterTable.dispose();
    }
}

