/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.BSimFilter;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.ResponseVectorMatch;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class QueryVectorMatch
extends BSimQuery<ResponseVectorMatch> {
    public static final int DEFAULT_MAX_FUNCTIONS = 200;
    public ResponseVectorMatch matchresponse;
    public int max = 200;
    public boolean fillinCategories = true;
    public BSimFilter bsimFilter = null;
    public List<Long> vectorIds = new ArrayList<Long>();

    public QueryVectorMatch() {
        super("queryvectormatch");
    }

    @Override
    public void buildResponseTemplate() {
        if (this.response == null) {
            this.matchresponse = new ResponseVectorMatch();
            this.response = this.matchresponse;
        }
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name).append(">\n");
        fwrite.append("<max>").append(SpecXmlUtils.encodeSignedInteger((long)this.max)).append("</max>\n");
        if (!this.fillinCategories) {
            fwrite.append("<categories>false</categories>\n");
        }
        if (this.bsimFilter != null) {
            this.bsimFilter.saveXml(fwrite);
        }
        for (Long id : this.vectorIds) {
            fwrite.append("<id>0x").append(SpecXmlUtils.encodeUnsignedInteger((long)id)).append("</id>\n");
        }
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        this.fillinCategories = true;
        parser.start(new String[]{this.name});
        parser.start(new String[]{"max"});
        this.max = SpecXmlUtils.decodeInt((String)parser.end().getText());
        while (parser.peek().isStart()) {
            XmlElement el = parser.peek();
            if (el.getName().equals("categories")) {
                parser.start(new String[0]);
                this.fillinCategories = SpecXmlUtils.decodeBoolean((String)parser.end().getText());
                continue;
            }
            if (el.getName().equals("exefilter")) {
                this.bsimFilter = new BSimFilter();
                this.bsimFilter.restoreXml(parser);
                continue;
            }
            if (el.getName().equals("id")) {
                parser.start(new String[0]);
                long val = SpecXmlUtils.decodeLong((String)parser.end().getText());
                this.vectorIds.add(val);
                continue;
            }
            throw new LSHException("Unknown tag: " + el.getName());
        }
        parser.end();
    }
}

