/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.matcher;

import ghidra.features.base.memsearch.bytesequence.ExtendedByteSequence;
import ghidra.features.base.memsearch.gui.SearchSettings;
import java.util.Objects;

public abstract class ByteMatcher {
    private final String input;
    private final SearchSettings settings;

    protected ByteMatcher(String input, SearchSettings settings) {
        this.input = input;
        this.settings = settings;
    }

    public final String getInput() {
        return this.input == null ? "" : this.input;
    }

    public SearchSettings getSettings() {
        return this.settings;
    }

    public abstract Iterable<ByteMatch> match(ExtendedByteSequence var1);

    public abstract String getDescription();

    public abstract String getToolTip();

    public boolean isValidSearch() {
        return true;
    }

    public boolean isValidInput() {
        return true;
    }

    public String toString() {
        return this.input;
    }

    public int hashCode() {
        return this.input.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteMatcher other = (ByteMatcher)obj;
        return Objects.equals(this.input, other.input) && this.settings.getSearchFormat() == other.settings.getSearchFormat();
    }

    public record ByteMatch(int start, int length) {
    }
}

