/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.util.HelpLocation;

public class DisableFieldAction
extends DockingAction {
    private FieldHeaderLocation loc;
    private FieldHeader panel;

    public DisableFieldAction(String owner, FieldHeader panel) {
        super("Disable Field", owner, false);
        this.panel = panel;
        this.setPopupMenuData(new MenuData(new String[]{"Disable Field"}, "field"));
        this.setEnabled(true);
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "Disable Field"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        Object contextObject = context.getContextObject();
        if (contextObject instanceof FieldHeaderLocation) {
            this.loc = (FieldHeaderLocation)contextObject;
            FieldFactory ff = this.loc.getFieldFactory();
            return ff != null && ff.isEnabled();
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        FieldFactory factory = this.loc.getFieldFactory();
        this.panel.setTabLock(true);
        factory.setEnabled(false);
    }
}

