/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramWrapperLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MapLoader
extends AbstractProgramWrapperLoader {
    public static final String MAP_NAME = "Program Mapfile (MAP)";
    public static final String NO_MAGIC = "0";

    @Override
    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        if (provider.getName() != null && provider.getName().toLowerCase().endsWith(".map")) {
            try {
                if (!this.parseMapFile(provider, TaskMonitor.DUMMY, null).isEmpty()) {
                    List<QueryResult> results = QueryOpinionService.query(this.getName(), NO_MAGIC, null);
                    for (QueryResult result : results) {
                        loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
                    }
                    if (loadSpecs.isEmpty()) {
                        loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
                    }
                }
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
        return loadSpecs;
    }

    @Override
    public void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program prog, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        if (!prog.getExecutableFormat().equals("Portable Executable (PE)")) {
            throw new IOException("Program must be a Portable Executable (PE)");
        }
        SymbolTable symtab = prog.getSymbolTable();
        AddressSpace space = prog.getAddressFactory().getDefaultAddressSpace();
        int successCount = 0;
        List<MapSymbol> symbols = this.parseMapFile(provider, monitor, log);
        monitor.initialize((long)symbols.size(), "Creating symbols...");
        for (MapSymbol symbol : symbols) {
            monitor.increment();
            try {
                Address addr = space.getAddress(symbol.addr);
                symtab.createLabel(addr, symbol.name, SourceType.IMPORTED).setPrimary();
                ++successCount;
            }
            catch (InvalidInputException e) {
                log.appendMsg("Error creating symbol '%s': %s".formatted(symbol.name, e.getMessage()));
            }
        }
        log.appendMsg("Added " + successCount + " symbols.");
    }

    @Override
    public String getName() {
        return MAP_NAME;
    }

    @Override
    public boolean supportsLoadIntoProgram() {
        return true;
    }

    private List<MapSymbol> parseMapFile(ByteProvider provider, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        ArrayList<MapSymbol> symbols = new ArrayList<MapSymbol>();
        monitor.setMessage("Parsing MAP file...");
        monitor.setIndeterminate(true);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(provider.getInputStream(0L)));){
            String line;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                monitor.checkCancelled();
                ++lineNumber;
                if ((line = line.trim()).startsWith(";")) continue;
                if (line.contains("Publics by Value")) {
                    lineNumber = this.parseMapFileSection(reader, symbols, lineNumber, monitor, log);
                    continue;
                }
                if (!line.startsWith("Static symbols")) continue;
                lineNumber = this.parseMapFileSection(reader, symbols, lineNumber, monitor, log);
            }
        }
        return symbols;
    }

    private int parseMapFileSection(BufferedReader reader, List<MapSymbol> list, int lineNumber, TaskMonitor monitor, MessageLog log) throws IOException, CancelledException {
        String line;
        boolean added = false;
        while ((line = reader.readLine()) != null) {
            monitor.checkCancelled();
            ++lineNumber;
            if ((line = line.trim()).startsWith(";")) continue;
            if (!line.isEmpty()) {
                try {
                    list.add(this.parseMapSymbol(line, lineNumber));
                    added = true;
                }
                catch (ParseException e) {
                    if (log == null) continue;
                    log.appendMsg(e.getMessage());
                }
                continue;
            }
            if (!added) continue;
            break;
        }
        return lineNumber;
    }

    private MapSymbol parseMapSymbol(String line, int lineNumber) throws ParseException {
        String[] parts = line.split("\\s+", 4);
        if (parts.length < 3) {
            throw new ParseException("Line %d has less than 3 fields (%d)".formatted(lineNumber, parts.length), lineNumber);
        }
        try {
            return new MapSymbol(parts[1], Long.parseLong(parts[2], 16));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Line %d address '%s' could not be converted to a number".formatted(lineNumber, parts[2]), lineNumber);
        }
    }

    private record MapSymbol(String name, long addr) {
    }
}

