/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype.microsoft;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import java.util.ArrayList;

public class GroupIconResourceDataType
extends DynamicDataType {
    public GroupIconResourceDataType() {
        this(null, "GroupIconResource", null);
    }

    public GroupIconResourceDataType(DataTypeManager dtm) {
        this(null, "GroupIconResource", dtm);
    }

    protected GroupIconResourceDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new GroupIconResourceDataType(dtm);
    }

    public String getMnemonic(Settings settings) {
        return "GroupIconRes";
    }

    public String getDescription() {
        return "GroupIcon stored as a Resource";
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return "GroupIcon";
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<GroupIcon-Resource>";
    }

    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        ArrayList<ReadOnlyDataTypeComponent> comps = new ArrayList<ReadOnlyDataTypeComponent>();
        MemBuffer memBuffer = buf;
        int structureOffset = 0;
        try {
            comps.add(new ReadOnlyDataTypeComponent((DataType)this.GroupIconHeaderStructure(), (DynamicDataType)this, 6, comps.size(), structureOffset, "GroupIcon Header", null));
            int numIconDirEntries = memBuffer.getShort(structureOffset + 4);
            structureOffset += 6;
            for (int i = 0; i < numIconDirEntries; ++i) {
                comps.add(new ReadOnlyDataTypeComponent((DataType)this.GroupIconDirEntryStructure(), (DynamicDataType)this, 14, comps.size(), structureOffset, "GroupIcon Entry", null));
                structureOffset += 14;
            }
        }
        catch (MemoryAccessException e1) {
            Msg.debug((Object)((Object)this), (Object)"Error applying GroupIcon Resource Data Type.");
        }
        DataTypeComponent[] result = comps.toArray(new DataTypeComponent[comps.size()]);
        return result;
    }

    private StructureDataType GroupIconHeaderStructure() {
        StructureDataType struct = new StructureDataType("GRPICONDIR", 0);
        struct.add((DataType)WordDataType.dataType, "idReserved", null);
        struct.add((DataType)WordDataType.dataType, "idType", null);
        struct.add((DataType)WordDataType.dataType, "idCount", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    private StructureDataType GroupIconDirEntryStructure() {
        StructureDataType struct = new StructureDataType("GRPICONDIRENTRY", 0);
        struct.add((DataType)ByteDataType.dataType, "bWidth", null);
        struct.add((DataType)ByteDataType.dataType, "bHeight", null);
        struct.add((DataType)ByteDataType.dataType, "bColorCount", null);
        struct.add((DataType)ByteDataType.dataType, "bReserved", null);
        struct.add((DataType)WordDataType.dataType, "wPlanes", null);
        struct.add((DataType)WordDataType.dataType, "wBitCount", null);
        struct.add((DataType)DWordDataType.dataType, "dwBytesInResource", null);
        struct.add((DataType)WordDataType.dataType, "nId", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }
}

