/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.builder.ActionBuilder;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import ghidra.app.cmd.data.CreateDataBackgroundCmd;
import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.data.CreateDataInStructureBackgroundCmd;
import ghidra.app.cmd.data.CreateDataInStructureCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.plugin.core.compositeeditor.ComponentContext;
import ghidra.app.plugin.core.compositeeditor.ComponentProgramActionContext;
import ghidra.app.plugin.core.compositeeditor.ComponentStandAloneActionContext;
import ghidra.app.plugin.core.data.ChooseDataTypeAction;
import ghidra.app.plugin.core.data.CreateArrayAction;
import ghidra.app.plugin.core.data.CreateStructureAction;
import ghidra.app.plugin.core.data.CycleGroupAction;
import ghidra.app.plugin.core.data.DataAction;
import ghidra.app.plugin.core.data.DataSettingsDialog;
import ghidra.app.plugin.core.data.DataTypeSettingsDialog;
import ghidra.app.plugin.core.data.EditDataFieldDialog;
import ghidra.app.plugin.core.data.PointerDataAction;
import ghidra.app.plugin.core.data.RecentlyUsedAction;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.services.DataService;
import ghidra.app.services.DataTypeManagerService;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CycleGroup;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypeManagerChangeListenerAdapter;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.InteriorSelection;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Create Data in listing", description="Provides many actions for setting, changing and deleting data in the listing display.", servicesRequired={DataTypeManagerService.class}, servicesProvided={DataService.class}, eventsConsumed={ProgramActivatedPluginEvent.class})
public class DataPlugin
extends Plugin
implements DataService {
    static final int BACKGROUND_SELECTION_THRESHOLD = 2048;
    static final DataType POINTER_DATA_TYPE = new PointerDataType();
    private static final String BASIC_DATA_GROUP = "BasicData";
    private static final String DATA_MENU_POPUP_PATH = "Data";
    private static final String[] EDIT_DATA_TYPE_POPUP_PATH = new String[]{"Data", "Edit Data Type"};
    private static final String[] DATA_SETTINGS_POPUP_PATH = new String[]{"Data", "Settings..."};
    private static final String[] DEFAULT_SETTINGS_POPUP_PATH = new String[]{"Data", "Default Settings..."};
    private static final String[] DATATYPE_SETTINGS_POPUP_PATH = new String[]{"Settings..."};
    private static final String[] CHOOSE_DATA_TYPE_POPUP_PATH = new String[]{"Data", "Choose Data Type..."};
    private DataTypeManagerService dtmService;
    private DataTypeManagerChangeListenerAdapter adapter;
    private DataAction pointerAction;
    private DataAction recentlyUsedAction;
    private DockingAction editDataTypeAction;
    private CreateStructureAction createStructureAction;
    private CreateArrayAction createArrayAction;
    private ChooseDataTypeAction chooseDataTypeAction;
    private List<DataAction> favoriteActions = new ArrayList<DataAction>();
    private SwingUpdateManager favoritesUpdateManager;

    public DataPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
        this.favoritesUpdateManager = new SwingUpdateManager(1000, 30000, () -> this.updateFavoriteActions());
    }

    protected void init() {
        this.initializeServices();
        this.addCycleGroupActions();
        this.updateFavoriteActions();
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            this.favoritesUpdateManager.updateLater();
        }
    }

    private void createActions() {
        this.recentlyUsedAction = new RecentlyUsedAction(this);
        this.recentlyUsedAction.setEnabled(false);
        this.tool.addAction((DockingActionIf)this.recentlyUsedAction);
        this.createStructureAction = new CreateStructureAction(this);
        this.tool.addAction((DockingActionIf)this.createStructureAction);
        this.createArrayAction = new CreateArrayAction(this);
        this.tool.addAction((DockingActionIf)this.createArrayAction);
        this.pointerAction = new PointerDataAction(this);
        this.tool.addAction((DockingActionIf)this.pointerAction);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Edit Field", this.getName()).helpLocation(new HelpLocation("DataPlugin", "Quick_Edit_Field"))).popupMenuPath(new String[]{DATA_MENU_POPUP_PATH, "Edit Field..."})).popupMenuGroup(BASIC_DATA_GROUP)).keyBinding("ctrl shift E")).sharedKeyBinding()).withContext(ListingActionContext.class).enabledWhen(this::canEditField).onAction(this::editField).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Data Settings", this.getName()).sharedKeyBinding()).popupMenuPath(DATA_SETTINGS_POPUP_PATH)).popupMenuGroup("Settings")).withContext(ListingActionContext.class).enabledWhen(context -> this.isDataTypeSettingsAllowed((ListingActionContext)context, false)).onAction(context -> this.dataSettingsCallback((ListingActionContext)context)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Default Settings", this.getName()).sharedKeyBinding()).popupMenuPath(DEFAULT_SETTINGS_POPUP_PATH)).popupMenuGroup("Settings")).withContext(ListingActionContext.class).enabledWhen(context -> this.isDataTypeSettingsAllowed((ListingActionContext)context, true)).onAction(context -> this.editDefaultDataSettings((ListingActionContext)context)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Default Settings", this.getName()).sharedKeyBinding()).popupMenuPath(DATATYPE_SETTINGS_POPUP_PATH)).popupMenuGroup("Settings")).withContext(DataTypesActionContext.class).enabledWhen(context -> this.isDefaultDataTypeSettingsAllowed((DataTypesActionContext)((Object)context))).onAction(context -> this.editDefaultDataTypeSettings((DataTypesActionContext)((Object)context))).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Default Settings", this.getName()).sharedKeyBinding()).popupMenuPath(DATATYPE_SETTINGS_POPUP_PATH)).popupMenuGroup("Settings")).withContext(ComponentProgramActionContext.class).enabledWhen(context -> this.isDefaultComponentSettingsAllowed((ComponentContext)context)).onAction(context -> this.editDefaultComponentSettings((ComponentContext)context)).buildAndInstall((Tool)this.tool);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Default Settings", this.getName()).sharedKeyBinding()).popupMenuPath(DATATYPE_SETTINGS_POPUP_PATH)).popupMenuGroup("Settings")).withContext(ComponentStandAloneActionContext.class).enabledWhen(context -> this.isDefaultComponentSettingsAllowed((ComponentContext)context)).onAction(context -> this.editDefaultComponentSettings((ComponentContext)context)).buildAndInstall((Tool)this.tool);
        this.editDataTypeAction = (DockingAction)((ActionBuilder)((ActionBuilder)new ActionBuilder("Edit Data Type", this.getName()).popupMenuPath(EDIT_DATA_TYPE_POPUP_PATH)).popupMenuGroup(BASIC_DATA_GROUP)).withContext(ListingActionContext.class).enabledWhen(c -> {
            DataType editableDt = this.getEditableDataTypeFromContext((ListingActionContext)c);
            if (editableDt != null) {
                HelpLocation helps = this.dtmService.getEditorHelpLocation(editableDt);
                this.editDataTypeAction.setHelpLocation(helps);
                return true;
            }
            return false;
        }).onAction(c -> this.editDataTypeCallback((ListingActionContext)c)).helpLocation(new HelpLocation("DataTypeEditors", "Structure_Editor")).buildAndInstall((Tool)this.tool);
        this.chooseDataTypeAction = new ChooseDataTypeAction(this);
        this.chooseDataTypeAction.setEnabled(false);
        this.chooseDataTypeAction.setPopupMenuData(new MenuData(CHOOSE_DATA_TYPE_POPUP_PATH, BASIC_DATA_GROUP));
        this.chooseDataTypeAction.setEnabled(true);
        this.chooseDataTypeAction.setHelpLocation(new HelpLocation("DataTypeEditors", "DataTypeSelectionDialog"));
        this.tool.addAction((DockingActionIf)this.chooseDataTypeAction);
    }

    private void initializeServices() {
        this.dtmService = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        if (this.dtmService == null) {
            throw new AssertException("DataTypeManagerService was not found!");
        }
        this.adapter = new DataTypeManagerChangeListenerAdapter(){

            public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
                DataPlugin.this.favoritesUpdateManager.update();
            }
        };
        this.dtmService.addDataTypeManagerChangeListener((DataTypeManagerChangeListener)this.adapter);
    }

    DataType getEditableDataTypeFromContext(ListingActionContext context) {
        ProgramSelection selection = context.getSelection();
        Program program = context.getProgram();
        Data data = null;
        if (selection != null && !selection.isEmpty()) {
            boolean isDataOnly;
            Listing listing = program.getListing();
            boolean bl = isDataOnly = !listing.getInstructions((AddressSetView)selection, true).hasNext();
            if (isDataOnly) {
                data = this.getDataUnit(context);
            }
        } else {
            data = this.getDataUnit(context);
        }
        return this.getEditableDataType(data);
    }

    private DataType getEditableDataType(Data data) {
        if (data == null || this.dtmService == null) {
            return null;
        }
        DataType baseDt = data.getBaseDataType();
        if (this.dtmService.isEditable(baseDt)) {
            return baseDt;
        }
        Data pdata = data.getParent();
        if (pdata != null && this.dtmService.isEditable(baseDt = pdata.getBaseDataType())) {
            return baseDt;
        }
        return null;
    }

    @Override
    public boolean createData(DataType dt, ListingActionContext context, boolean stackPointers, boolean enableConflictHandling) {
        ProgramLocation location = context.getLocation();
        if (!(location instanceof CodeUnitLocation)) {
            return false;
        }
        return this.doCreateData(context, dt, stackPointers);
    }

    boolean doCreateData(ListingActionContext context, DataType dt, boolean stackPointers) {
        ProgramSelection selection = context.getSelection();
        ProgramLocation location = context.getLocation();
        Program program = context.getProgram();
        dt = dt.clone((DataTypeManager)program.getDataTypeManager());
        boolean didCreateData = false;
        if (selection != null && !selection.isEmpty()) {
            didCreateData = this.createDataForSelection(program, dt, stackPointers, selection);
        } else if (location != null) {
            didCreateData = this.createDataAtLocation(program, dt, stackPointers, location);
        }
        this.updateRecentlyUsed(dt);
        return didCreateData;
    }

    private boolean createDataAtLocation(Program program, DataType dt, boolean stackPointers, ProgramLocation location) {
        Object cmd;
        Address start = location.getAddress();
        int[] startPath = location.getComponentPath();
        if (startPath != null && startPath.length != 0) {
            cmd = new CreateDataInStructureCmd(start, startPath, dt, stackPointers);
        } else {
            if (!this.checkEnoughSpace(program, start, dt, stackPointers)) {
                return false;
            }
            cmd = new CreateDataCmd(start, true, stackPointers, dt);
        }
        return this.getTool().execute((Command)cmd, (DomainObject)program);
    }

    private boolean createDataForSelection(Program program, DataType dt, boolean stackPointers, ProgramSelection selection) {
        BackgroundCommand cmd;
        Address start = selection.getMinAddress();
        InteriorSelection interSel = selection.getInteriorSelection();
        if (interSel != null) {
            int[] startPath = interSel.getFrom().getComponentPath();
            int length = (int)selection.getNumAddresses();
            cmd = new CreateDataInStructureBackgroundCmd(start, startPath, length, dt, stackPointers);
        } else {
            cmd = new CreateDataBackgroundCmd(selection, dt, stackPointers);
        }
        boolean didCreateData = false;
        if (selection.getNumAddresses() < 2048L) {
            didCreateData = this.getTool().execute((Command)cmd, (DomainObject)program);
        } else {
            this.getTool().executeBackgroundCommand(cmd, (DomainObject)program);
        }
        return didCreateData;
    }

    private boolean checkEnoughSpace(Program program, Address start, DataType dataType, boolean stackingEnabled) {
        Listing listing = program.getListing();
        Data data = listing.getDataAt(start);
        if (data == null) {
            this.tool.setStatusInfo("Invalid data location.  Cannot create data at " + String.valueOf(start) + ".");
            return false;
        }
        if (stackingEnabled && this.canConvertPointer(dataType, data)) {
            return true;
        }
        int newSize = this.getDataTypeSize(program, dataType, start);
        if (newSize == 1) {
            return true;
        }
        if (newSize <= 0) {
            this.tool.setStatusInfo("Invalid data location.  Unable to resolve data length at " + String.valueOf(start) + " for " + dataType.getName());
            return false;
        }
        Address end = null;
        try {
            end = start.addNoWrap((long)(newSize - 1));
        }
        catch (AddressOverflowException e) {
            this.tool.setStatusInfo("Invalid data location.  Not enough space at " + String.valueOf(start) + " for " + newSize + " bytes.");
            return false;
        }
        if (this.instructionExists(listing, dataType, start, end)) {
            this.tool.setStatusInfo("Invalid data location.  Instruction exists at " + String.valueOf(start) + ".");
            return false;
        }
        MemoryBlock memBlock = program.getMemory().getBlock(start);
        Address blockMaxAddress = memBlock.getEnd();
        if (blockMaxAddress.compareTo((Object)end) < 0) {
            this.tool.setStatusInfo("Create " + dataType.getName() + " failed: Not enough room in memory block containing address " + String.valueOf(start) + " which ends at " + String.valueOf(blockMaxAddress) + ".");
            return false;
        }
        Data definedData = DataUtilities.getNextNonUndefinedDataAfter((Program)program, (Address)start, (Address)blockMaxAddress);
        return !this.dataExists(program, dataType, definedData, start, end);
    }

    private boolean canConvertPointer(DataType dataType, Data existingData) {
        if (!existingData.isDefined()) {
            return false;
        }
        if (dataType instanceof FactoryDataType) {
            return false;
        }
        if (dataType instanceof Pointer) {
            return false;
        }
        DataType existingDT = existingData.getDataType();
        return existingDT instanceof Pointer;
    }

    private boolean dataExists(Program program, DataType dataType, Data definedData, Address start, Address end) {
        if (definedData == null) {
            return false;
        }
        if (definedData.getMinAddress().compareTo((Object)end) > 0) {
            return false;
        }
        int resp = OptionDialog.showYesNoCancelDialog((Component)this.tool.getActiveWindow(), (String)"Data Conflict", (String)("Data applied from " + String.valueOf(start) + " to " + String.valueOf(end) + "\nconflicts with existing defined data!\n\nClear conflicting data?"));
        if (resp != 1) {
            this.tool.setStatusInfo("Create " + dataType.getName() + " failed: Data exists at address " + String.valueOf(definedData.getMinAddress()) + " to " + String.valueOf(definedData.getMaxAddress()));
            return true;
        }
        return false;
    }

    private boolean instructionExists(Listing listing, DataType dataType, Address start, Address end) {
        Instruction instruction = listing.getInstructionAfter(start);
        if (instruction == null) {
            return false;
        }
        String dtName = dataType.getName();
        Address minAddress = instruction.getMinAddress();
        if (minAddress.compareTo((Object)end) <= 0) {
            this.tool.setStatusInfo("Create " + dtName + " failed: Instruction exists at address " + String.valueOf(minAddress) + " to " + String.valueOf(instruction.getMaxAddress()));
            return true;
        }
        return false;
    }

    private int getDataTypeSize(Program program, DataType dataType, Address start) {
        int newSize = dataType.getLength();
        if (newSize >= 0) {
            return newSize;
        }
        DataTypeInstance dataTypeInstance = DataTypeInstance.getDataTypeInstance((DataType)dataType, (MemBuffer)new DumbMemBufferImpl(program.getMemory(), start), (boolean)false);
        if (dataTypeInstance == null) {
            this.tool.setStatusInfo("Unallowed data type at " + String.valueOf(start) + ": " + dataType.getName());
            return -1;
        }
        return dataTypeInstance.getLength();
    }

    PluginTool getPluginTool() {
        return this.tool;
    }

    private void clearActions(List<DataAction> actions) {
        for (DockingAction dockingAction : actions) {
            this.tool.removeAction((DockingActionIf)dockingAction);
            dockingAction.dispose();
        }
        actions.clear();
    }

    private void addCycleGroupActions() {
        if (this.dtmService == null) {
            return;
        }
        for (CycleGroup group : CycleGroup.ALL_CYCLE_GROUPS) {
            CycleGroupAction action = new CycleGroupAction(group, this);
            action.setEnabled(false);
            this.tool.addAction((DockingActionIf)action);
        }
    }

    private void updateFavoriteActions() {
        if (this.dtmService == null) {
            return;
        }
        this.clearActions(this.favoriteActions);
        List<DataType> favoritesList = this.dtmService.getFavorites();
        for (DataType dataType : favoritesList) {
            if (dataType.isEquivalent(POINTER_DATA_TYPE)) continue;
            DataAction action = new DataAction(dataType, this);
            this.tool.addAction((DockingActionIf)action);
            this.favoriteActions.add(action);
        }
    }

    void updateRecentlyUsed(DataType dt) {
        if (this.dtmService != null) {
            this.dtmService.setRecentlyUsed(dt);
        }
    }

    private boolean isSelectionJustSingleDataInstance(ProgramSelection selection, Data data) {
        if (selection != null && data != null) {
            AddressSet dataAS = new AddressSet(data.getAddress(), data.getMaxAddress());
            return dataAS.hasSameAddresses((AddressSetView)selection);
        }
        return false;
    }

    private void dataSettingsCallback(ListingActionContext context) {
        DataSettingsDialog dialog;
        Data data = this.getDataUnit(context);
        ProgramSelection selection = context.getSelection();
        if (selection != null && !selection.isEmpty() && !this.isSelectionJustSingleDataInstance(selection, data)) {
            try {
                dialog = new DataSettingsDialog(context.getProgram(), selection);
            }
            catch (CancelledException e) {
                return;
            }
            if (!dialog.hasSettings()) {
                Msg.showError((Object)this, (Component)this.tool.getActiveWindow(), (String)"No Settings Found", (Object)"Common data settings were not found across selection");
                return;
            }
        } else {
            if (data == null) {
                return;
            }
            dialog = new DataSettingsDialog(data);
        }
        this.tool.showDialog((DialogComponentProvider)dialog);
        dialog.dispose();
    }

    DataType getSelectedDataType(DataTypesActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return null;
        }
        DataTypeTreeNode node = (DataTypeTreeNode)((Object)selectionPaths[0].getLastPathComponent());
        if (!(node instanceof DataTypeNode)) {
            return null;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        if (dataType.getDataTypeManager() instanceof DataTypeManagerDB) {
            return dataType;
        }
        return null;
    }

    protected void editDefaultDataTypeSettings(DataTypesActionContext context) {
        DataType dataType = this.getSelectedDataType(context);
        if (dataType == null) {
            return;
        }
        DataTypeManager dtm = dataType.getDataTypeManager();
        if (!(dtm instanceof DataTypeManagerDB)) {
            return;
        }
        SettingsDefinition[] settingsDefinitions = dataType.getSettingsDefinitions();
        if (!(dtm instanceof ProgramDataTypeManager)) {
            settingsDefinitions = SettingsDefinition.filterSettingsDefinitions((SettingsDefinition[])settingsDefinitions, def -> def instanceof TypeDefSettingsDefinition);
        }
        DataTypeSettingsDialog dialog = new DataTypeSettingsDialog(dataType, settingsDefinitions);
        this.tool.showDialog((DialogComponentProvider)dialog);
        dialog.dispose();
    }

    private void editDefaultComponentSettings(ComponentContext context) {
        DataTypeSettingsDialog dialog = new DataTypeSettingsDialog(context.getDataTypeComponent());
        this.tool.showDialog((DialogComponentProvider)dialog);
        dialog.dispose();
        dialog = null;
    }

    protected boolean isDefaultDataTypeSettingsAllowed(DataTypesActionContext context) {
        DataType dt = this.getSelectedDataType(context);
        if (dt == null) {
            return false;
        }
        DataTypeManager dtm = dt.getDataTypeManager();
        if (dtm instanceof BuiltInDataTypeManager) {
            return false;
        }
        if (dt instanceof BuiltIn && !dtm.allowsDefaultBuiltInSettings()) {
            return false;
        }
        SettingsDefinition[] settingsDefinitions = dt.getSettingsDefinitions();
        if (dtm instanceof ProgramBasedDataTypeManager) {
            return settingsDefinitions.length != 0;
        }
        for (SettingsDefinition def : settingsDefinitions) {
            if (!(def instanceof TypeDefSettingsDefinition)) continue;
            return true;
        }
        return false;
    }

    boolean isDefaultComponentSettingsAllowed(ComponentContext context) {
        DataTypeManager targetDtm = context.getDataTypeManager();
        if (targetDtm.allowsDefaultComponentSettings()) {
            DataType dt = context.getDataTypeComponent().getDataType();
            return dt.getSettingsDefinitions().length != 0;
        }
        return false;
    }

    boolean isDataTypeSettingsAllowed(ListingActionContext context, boolean editDefaults) {
        ProgramSelection selection = context.getSelection();
        Data data = this.getDataUnit(context);
        if (selection != null && !selection.isEmpty() && !this.isSelectionJustSingleDataInstance(selection, data)) {
            return !editDefaults;
        }
        if (data == null) {
            return false;
        }
        return data.getDataType().getSettingsDefinitions().length != 0;
    }

    private void editDefaultDataSettings(ListingActionContext context) {
        DataType parentDT;
        Data data = this.getDataUnit(context);
        if (data == null) {
            return;
        }
        DataTypeSettingsDialog dialog = null;
        Data parent = data.getParent();
        if (parent != null && (parentDT = parent.getDataType()) instanceof Composite) {
            int[] path = context.getLocation().getComponentPath();
            dialog = new DataTypeSettingsDialog(((Composite)parentDT).getComponent(path[path.length - 1]));
        }
        if (dialog == null) {
            DataType dt = data.getDataType();
            dialog = new DataTypeSettingsDialog(dt, dt.getSettingsDefinitions());
        }
        this.tool.showDialog(dialog);
        dialog.dispose();
        dialog = null;
    }

    private void editDataTypeCallback(ListingActionContext context) {
        Data data = this.getDataUnit(context);
        if (data == null) {
            return;
        }
        DataType dataType = data.getBaseDataType();
        if (this.dtmService.isEditable(dataType)) {
            this.dtmService.edit(dataType);
        } else if ((data = data.getParent()) != null && this.dtmService.isEditable(dataType = data.getBaseDataType())) {
            this.dtmService.edit(dataType);
        }
    }

    public void dispose() {
        this.favoritesUpdateManager.dispose();
        if (this.dtmService != null) {
            this.dtmService.removeDataTypeManagerChangeListener((DataTypeManagerChangeListener)this.adapter);
        }
        super.dispose();
        this.favoriteActions.clear();
        this.createStructureAction.dispose();
    }

    Data getDataUnit(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        ProgramSelection selection = context.getSelection();
        Program program = context.getProgram();
        if (!(location instanceof CodeUnitLocation)) {
            return null;
        }
        Address start = location.getAddress();
        if (selection != null && !selection.isEmpty()) {
            start = selection.getMinAddress();
            if (selection.getInteriorSelection() != null) {
                location = selection.getInteriorSelection().getFrom();
            }
        }
        return DataPlugin.getDataUnit(program, start, location.getComponentPath());
    }

    static Data getDataUnit(Program program, Address start, int[] componentPath) {
        if (start == null) {
            return null;
        }
        Data data = program.getListing().getDataContaining(start);
        if (data == null) {
            return null;
        }
        if (data.getNumComponents() <= 0) {
            return data;
        }
        if (componentPath == null || componentPath.length <= 0) {
            return data;
        }
        Data compData = data.getComponent(componentPath);
        return compData == null ? data : compData;
    }

    @Override
    public boolean isCreateDataAllowed(ListingActionContext context) {
        ProgramLocation location = context.getLocation();
        if (!(location instanceof CodeUnitLocation)) {
            return false;
        }
        Data data = this.getDataUnit(context);
        if (data == null) {
            return false;
        }
        Data pdata = data.getParent();
        return pdata == null || !pdata.isArray();
    }

    private boolean canEditField(ListingActionContext context) {
        Address address;
        ProgramLocation location = context.getLocation();
        int[] path = location.getComponentPath();
        if (path == null || path.length == 0) {
            return false;
        }
        Program program = context.getProgram();
        DataTypeComponent dtc = DataTypeUtils.getDataTypeComponent(program, address = location.getAddress(), path);
        return dtc != null;
    }

    private void editField(ListingActionContext context) {
        Program program = context.getProgram();
        ProgramLocation location = context.getLocation();
        Address address = location.getAddress();
        int[] path = location.getComponentPath();
        DataTypeComponent dtc = DataTypeUtils.getDataTypeComponent(program, address, path);
        DataType parent = dtc.getParent();
        Composite composite = (Composite)parent;
        int ordinal = dtc.getOrdinal();
        EditDataFieldDialog dialog = new EditDataFieldDialog(this.tool, this.dtmService, composite, program, address, ordinal);
        this.tool.showDialog((DialogComponentProvider)dialog);
    }
}

