/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server.security;

import ghidra.framework.remote.GhidraPrincipal;
import ghidra.server.UserManager;
import ghidra.server.security.AuthenticationModule;
import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.StringUtils;

public class PasswordFileAuthenticationModule
implements AuthenticationModule {
    private final boolean nameCallbackAllowed;

    public PasswordFileAuthenticationModule(boolean nameCallbackAllowed) {
        this.nameCallbackAllowed = nameCallbackAllowed;
    }

    @Override
    public boolean anonymousCallbacksAllowed() {
        return true;
    }

    @Override
    public Callback[] getAuthenticationCallbacks() {
        return AuthenticationModule.createSimpleNamePasswordCallbacks(this.nameCallbackAllowed);
    }

    @Override
    public boolean isNameCallbackAllowed() {
        return this.nameCallbackAllowed;
    }

    @Override
    public String authenticate(UserManager userMgr, Subject subject, Callback[] callbacks) throws LoginException {
        GhidraPrincipal user = GhidraPrincipal.getGhidraPrincipal((Subject)subject);
        if (user == null) {
            throw new FailedLoginException("GhidraPrincipal required");
        }
        String username = user.getName();
        NameCallback nameCb = AuthenticationModule.getFirstCallbackOfType(NameCallback.class, callbacks);
        PasswordCallback passCb = AuthenticationModule.getFirstCallbackOfType(PasswordCallback.class, callbacks);
        if (this.nameCallbackAllowed && nameCb != null) {
            username = nameCb.getName();
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new FailedLoginException("User ID must be specified");
        }
        if (passCb == null) {
            throw new FailedLoginException("Password callback required");
        }
        char[] pass = passCb.getPassword();
        passCb.clearPassword();
        try {
            userMgr.authenticateUser(username, pass);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            throw new FailedLoginException(msg);
        }
        finally {
            if (pass != null) {
                Arrays.fill(pass, ' ');
            }
        }
        return username;
    }
}

