/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.buffers.DataBuffer;
import db.buffers.IndexProvider;
import db.buffers.LocalBufferFile;
import ghidra.util.datastruct.IntIntHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.NoValueException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.NoSuchElementException;

class RecoveryFile {
    private static final int MAGIC_NUMBER = 954103380;
    private static final int VALID = 1;
    private static final int INVALID = 0;
    private static final String RECOVERY_PARM_PREFIX = "~RF.";
    private static final String MAGIC_NUMBER_PARM = "~RF.VersionFile";
    private static final String SRC_FILE_ID_HI_PARM = "~RF.SrcIdHi";
    private static final String SRC_FILE_ID_LOW_PARM = "~RF.SrcIdLow";
    private static final String IS_VALID_PARM = "~RF.OrigBufCnt";
    private static final String TIMESTAMP_HI_PARM = "~RF.TimestampHi";
    private static final String TIMESTAMP_LOW_PARM = "~RF.TimestampLow";
    private static final String MAP_BUFFER_INDEX_PARM = "~RF.MapIndex";
    private static final String FREE_LIST_BUFFER_INDEX_PARM = "~RF.FreeListIndex";
    private static final String FREE_LIST_SIZE_PARM = "~RF.FreeListSize";
    private static final String INDEX_COUNT_PARM = "~RF.BufferCount";
    private static final String BAD_FREE_LIST = "Recovery file is corrupt - bad free list";
    private static final String BAD_BUFFER_MAP = "Recovery file is corrupt - bad buffer map";
    private static final int NEXT_BUFFER_INDEX_OFFSET = 0;
    private static final int FIRST_ENTRY_OFFSET = 4;
    private boolean readOnly;
    private boolean valid = false;
    private long timestamp;
    private boolean modified = false;
    private LocalBufferFile recoveryFile;
    private long srcFileId;
    private int indexCnt;
    private IndexProvider vfIndexProvider;
    private int freeListIndex = -1;
    private int mapIndex = -1;
    private int[] freeIndexes;
    private IntIntHashtable bufferIndexMap = new IntIntHashtable();

    RecoveryFile(LocalBufferFile srcBf, File rfile, boolean create) throws IOException {
        this.readOnly = false;
        if (create) {
            this.indexCnt = srcBf.getIndexCount();
            this.recoveryFile = new LocalBufferFile(rfile, srcBf.getBufferSize());
            this.recoveryFile.setParameter(MAGIC_NUMBER_PARM, 954103380);
            this.recoveryFile.setParameter(IS_VALID_PARM, 0);
            this.srcFileId = srcBf.getFileId();
            this.recoveryFile.setParameter(SRC_FILE_ID_HI_PARM, (int)(this.srcFileId >>> 32));
            this.recoveryFile.setParameter(SRC_FILE_ID_LOW_PARM, (int)(this.srcFileId & 0xFFFFFFFFL));
            this.vfIndexProvider = new IndexProvider();
            this.modified = true;
        } else {
            this.recoveryFile = new LocalBufferFile(rfile, false);
            boolean bl = this.valid = this.recoveryFile.getParameter(IS_VALID_PARM) == 1;
            if (!this.valid) {
                throw new IOException("Can not update invalid recovery file");
            }
            this.parseFile();
            if (this.srcFileId != srcBf.getFileId()) {
                throw new IOException("Recovery file not associated with source file");
            }
            this.vfIndexProvider = new IndexProvider(this.recoveryFile.getIndexCount(), this.recoveryFile.getFreeIndexes());
        }
    }

    RecoveryFile(LocalBufferFile srcBf, File rfile) throws IOException {
        this.recoveryFile = new LocalBufferFile(rfile, true);
        this.readOnly = true;
        this.parseFile();
        this.valid = this.recoveryFile.getParameter(IS_VALID_PARM) == 1 && this.srcFileId == srcBf.getFileId();
    }

    private void setModified() {
        if (this.valid) {
            this.recoveryFile.setParameter(IS_VALID_PARM, 0);
            this.valid = false;
            this.modified = true;
        }
    }

    File getFile() {
        return this.recoveryFile.getFile();
    }

    boolean isValid() {
        return this.valid;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    void close() throws IOException {
        if (this.recoveryFile == null) {
            return;
        }
        if (!this.readOnly && this.modified && !this.recoveryFile.isReadOnly()) {
            this.saveBufferMap();
            this.saveFreeIndexList();
            this.recoveryFile.setParameter(INDEX_COUNT_PARM, this.indexCnt);
            this.recoveryFile.setFreeIndexes(this.vfIndexProvider.getFreeIndexes());
            long t = new Date().getTime();
            this.recoveryFile.setParameter(TIMESTAMP_HI_PARM, (int)(t >>> 32));
            this.recoveryFile.setParameter(TIMESTAMP_LOW_PARM, (int)(t & 0xFFFFFFFFL));
            this.recoveryFile.setParameter(IS_VALID_PARM, 1);
        }
        this.recoveryFile.close();
        this.recoveryFile = null;
    }

    private void parseFile() throws IOException {
        try {
            if (954103380 != this.recoveryFile.getParameter(MAGIC_NUMBER_PARM)) {
                throw new IOException("Invalid recovery file");
            }
            try {
                this.timestamp = (long)this.recoveryFile.getParameter(TIMESTAMP_HI_PARM) << 32 | (long)this.recoveryFile.getParameter(TIMESTAMP_LOW_PARM) & 0xFFFFFFFFL;
            }
            catch (NoSuchElementException e) {
                this.timestamp = this.recoveryFile.getFile().lastModified();
            }
            this.srcFileId = (long)this.recoveryFile.getParameter(SRC_FILE_ID_HI_PARM) << 32 | (long)this.recoveryFile.getParameter(SRC_FILE_ID_LOW_PARM) & 0xFFFFFFFFL;
            this.indexCnt = this.recoveryFile.getParameter(INDEX_COUNT_PARM);
            this.readBufferMap();
            this.readFreeIndexList();
        }
        catch (NoSuchElementException e) {
            throw new IOException("Corrupt recovery file");
        }
    }

    private void saveBufferMap() throws IOException {
        DataBuffer buf = new DataBuffer(this.recoveryFile.getBufferSize());
        if (this.mapIndex < 0) {
            this.mapIndex = this.vfIndexProvider.allocateIndex();
            buf.setId(this.mapIndex);
            buf.putInt(0, -1);
            this.recoveryFile.setParameter(MAP_BUFFER_INDEX_PARM, this.mapIndex);
        } else {
            this.recoveryFile.get(buf, this.mapIndex);
        }
        int maxOffset = this.recoveryFile.getBufferSize() - 8 & 0xFFFFFFF8;
        int offset = 4;
        int thisIndex = this.mapIndex;
        int[] realIndexes = this.bufferIndexMap.getKeys();
        for (int i = 0; i <= realIndexes.length; ++i) {
            if (offset > maxOffset) {
                boolean newBuf = false;
                int nextIndex = buf.getInt(0);
                if (nextIndex < 0) {
                    nextIndex = this.vfIndexProvider.allocateIndex();
                    newBuf = true;
                }
                buf.putInt(0, nextIndex);
                this.recoveryFile.put(buf, thisIndex);
                thisIndex = nextIndex;
                if (newBuf) {
                    buf.setId(thisIndex);
                    buf.putInt(0, -1);
                } else {
                    this.recoveryFile.get(buf, thisIndex);
                }
                offset = 4;
            }
            if (i == realIndexes.length) {
                buf.putInt(offset, -1);
                continue;
            }
            try {
                offset = buf.putInt(offset, realIndexes[i]);
                offset = buf.putInt(offset, this.bufferIndexMap.get(realIndexes[i]));
                continue;
            }
            catch (NoValueException e) {
                throw new AssertException();
            }
        }
        this.recoveryFile.put(buf, thisIndex);
    }

    private void readBufferMap() throws NoSuchElementException, IOException {
        this.mapIndex = this.recoveryFile.getParameter(MAP_BUFFER_INDEX_PARM);
        int maxOffset = this.recoveryFile.getBufferSize() - 8 & 0xFFFFFFF8;
        int thisIndex = this.mapIndex;
        DataBuffer mapBuffer = new DataBuffer();
        this.recoveryFile.get(mapBuffer, thisIndex);
        if (mapBuffer.isEmpty()) {
            throw new IOException(BAD_BUFFER_MAP);
        }
        int nextMapEntryOffset = 4;
        while (true) {
            int realIndex;
            if (nextMapEntryOffset > maxOffset) {
                thisIndex = mapBuffer.getInt(0);
                this.recoveryFile.get(mapBuffer, thisIndex);
                if (mapBuffer.isEmpty()) {
                    throw new IOException(BAD_BUFFER_MAP);
                }
                nextMapEntryOffset = 4;
            }
            if ((realIndex = mapBuffer.getInt(nextMapEntryOffset)) < 0) {
                return;
            }
            int recoveryIndex = mapBuffer.getInt(nextMapEntryOffset += 4);
            nextMapEntryOffset += 4;
            this.bufferIndexMap.put(realIndex, recoveryIndex);
        }
    }

    private void saveFreeIndexList() throws IOException {
        DataBuffer buf = new DataBuffer(this.recoveryFile.getBufferSize());
        if (this.freeListIndex < 0) {
            this.freeListIndex = this.vfIndexProvider.allocateIndex();
            buf.setId(this.freeListIndex);
            buf.putInt(0, -1);
            this.recoveryFile.setParameter(FREE_LIST_BUFFER_INDEX_PARM, this.freeListIndex);
        } else {
            this.recoveryFile.get(buf, this.freeListIndex);
        }
        this.recoveryFile.setParameter(FREE_LIST_SIZE_PARM, this.freeIndexes.length);
        int maxOffset = this.recoveryFile.getBufferSize() - 4 & 0xFFFFFFFC;
        int offset = 4;
        int thisIndex = this.freeListIndex;
        for (int i = 0; i <= this.freeIndexes.length; ++i) {
            if (offset > maxOffset) {
                boolean newBuf = false;
                int nextIndex = buf.getInt(0);
                if (nextIndex < 0) {
                    nextIndex = this.vfIndexProvider.allocateIndex();
                    newBuf = true;
                }
                buf.putInt(0, nextIndex);
                this.recoveryFile.put(buf, thisIndex);
                thisIndex = nextIndex;
                if (newBuf) {
                    buf.setId(thisIndex);
                    buf.putInt(0, -1);
                } else {
                    this.recoveryFile.get(buf, thisIndex);
                }
                offset = 4;
            }
            int val = i == this.freeIndexes.length ? -1 : this.freeIndexes[i];
            offset = buf.putInt(offset, val);
        }
        this.recoveryFile.put(buf, thisIndex);
    }

    private void readFreeIndexList() throws NoSuchElementException, IOException {
        this.freeListIndex = this.recoveryFile.getParameter(FREE_LIST_BUFFER_INDEX_PARM);
        int size = this.recoveryFile.getParameter(FREE_LIST_SIZE_PARM);
        this.freeIndexes = new int[size];
        int maxOffset = this.recoveryFile.getBufferSize() - 4 & 0xFFFFFFFC;
        int thisIndex = this.freeListIndex;
        DataBuffer listBuffer = new DataBuffer();
        this.recoveryFile.get(listBuffer, thisIndex);
        if (listBuffer.isEmpty()) {
            throw new IOException(BAD_FREE_LIST);
        }
        int offset = 4;
        int entryIx = 0;
        while (true) {
            int origIndex;
            if (offset > maxOffset) {
                thisIndex = listBuffer.getInt(0);
                this.recoveryFile.get(listBuffer, thisIndex);
                if (listBuffer.isEmpty()) {
                    throw new IOException(BAD_FREE_LIST);
                }
                offset = 4;
            }
            if ((origIndex = listBuffer.getInt(offset)) < 0) break;
            if (entryIx == size) {
                throw new IOException(BAD_FREE_LIST);
            }
            offset += 4;
            this.freeIndexes[entryIx++] = origIndex;
        }
        if (entryIx != size) {
            throw new IOException(BAD_FREE_LIST);
        }
        Arrays.sort(this.freeIndexes);
    }

    void setIndexCount(int newIndexCount) {
        this.setModified();
        for (int index = this.indexCnt; index < newIndexCount; ++index) {
            this.removeBuffer(index);
        }
        this.indexCnt = newIndexCount;
    }

    int getIndexCount() {
        return this.indexCnt;
    }

    void setFreeIndexList(int[] freeIndexes) {
        this.setModified();
        this.freeIndexes = (int[])freeIndexes.clone();
        Arrays.sort(this.freeIndexes);
        for (int index : freeIndexes) {
            this.removeBuffer(index);
        }
    }

    int[] getFreeIndexList() {
        return this.freeIndexes;
    }

    void putBuffer(DataBuffer buf) throws IOException {
        int vfIndex;
        if (this.recoveryFile == null) {
            throw new IOException("Version file is closed");
        }
        if (this.readOnly) {
            throw new IOException("Version file is read-only");
        }
        this.setModified();
        int id = buf.getId();
        try {
            vfIndex = this.bufferIndexMap.get(id);
        }
        catch (NoValueException e) {
            vfIndex = this.vfIndexProvider.allocateIndex();
            this.bufferIndexMap.put(id, vfIndex);
        }
        this.recoveryFile.put(buf, vfIndex);
    }

    void removeBuffer(int id) {
        this.setModified();
        try {
            int vfIndex = this.bufferIndexMap.remove(id);
            this.vfIndexProvider.freeIndex(vfIndex);
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
    }

    DataBuffer getBuffer(DataBuffer buf, int id) throws IOException {
        int vfIndex;
        if (this.recoveryFile == null) {
            throw new IOException("Version file is closed");
        }
        try {
            vfIndex = this.bufferIndexMap.get(id);
        }
        catch (NoValueException e) {
            return null;
        }
        this.recoveryFile.get(buf, vfIndex);
        return buf;
    }

    int[] getBufferIndexes() {
        return this.bufferIndexMap.getKeys();
    }

    long getSourceFileID() {
        return this.srcFileId;
    }

    String[] getUserParameterNames() throws IOException {
        if (this.recoveryFile == null) {
            throw new IOException("Version file is closed");
        }
        String[] allNames = this.recoveryFile.getParameterNames();
        ArrayList<String> list = new ArrayList<String>();
        for (String name : allNames) {
            if (name.startsWith(RECOVERY_PARM_PREFIX)) continue;
            list.add(name);
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    int getParameter(String name) throws IOException {
        if (this.recoveryFile == null) {
            throw new IOException("Version file is closed");
        }
        return this.recoveryFile.getParameter(name);
    }

    void clearParameters() {
        this.setModified();
        String[] allNames = this.recoveryFile.getParameterNames();
        Hashtable<String, Integer> recoveryProps = new Hashtable<String, Integer>();
        for (String name : allNames) {
            if (!name.startsWith(RECOVERY_PARM_PREFIX)) continue;
            recoveryProps.put(name, this.recoveryFile.getParameter(name));
        }
        this.recoveryFile.clearParameters();
        for (String name : recoveryProps.keySet()) {
            this.recoveryFile.setParameter(name, (Integer)recoveryProps.get(name));
        }
    }

    void setParameter(String name, int value) {
        this.setModified();
        this.recoveryFile.setParameter(name, value);
    }
}

