/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import React from 'react';
import type { TextBuffer } from './text-buffer.js';
/**
 * Generic interface for items in a searchable list.
 */
export interface GenericListItem {
    key: string;
    label: string;
    description?: string;
    [key: string]: unknown;
}
/**
 * State returned by the search hook.
 */
export interface SearchListState<T extends GenericListItem> {
    filteredItems: T[];
    searchBuffer: TextBuffer | undefined;
    searchQuery: string;
    setSearchQuery: (query: string) => void;
    maxLabelWidth: number;
}
/**
 * Props for the SearchableList component.
 */
export interface SearchableListProps<T extends GenericListItem> {
    title?: string;
    items: T[];
    onSelect: (item: T) => void;
    onClose: () => void;
    searchPlaceholder?: string;
    /** Custom item renderer */
    renderItem?: (item: T, isActive: boolean, labelWidth: number) => React.ReactNode;
    /** Optional header content */
    header?: React.ReactNode;
    /** Optional footer content */
    footer?: (info: {
        startIndex: number;
        endIndex: number;
        totalVisible: number;
    }) => React.ReactNode;
    maxItemsToShow?: number;
    /** Hook to handle search logic */
    useSearch: (props: {
        items: T[];
        onSearch?: (query: string) => void;
    }) => SearchListState<T>;
    onSearch?: (query: string) => void;
    /** Whether to reset selection to the top when items change (e.g. after search) */
    resetSelectionOnItemsChange?: boolean;
}
/**
 * A generic searchable list component with keyboard navigation.
 */
export declare function SearchableList<T extends GenericListItem>({ title, items, onSelect, onClose, searchPlaceholder, renderItem, header, footer, maxItemsToShow, useSearch, onSearch, resetSelectionOnItemsChange, }: SearchableListProps<T>): React.JSX.Element;
