/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Orchestrator for tool definitions.
 * Resolves the correct toolset based on model family and provides legacy exports.
 */
import type { ToolDefinition, CoreToolSet } from './types.js';
export { GLOB_TOOL_NAME, GREP_TOOL_NAME, LS_TOOL_NAME, READ_FILE_TOOL_NAME, SHELL_TOOL_NAME, WRITE_FILE_TOOL_NAME, EDIT_TOOL_NAME, WEB_SEARCH_TOOL_NAME, WRITE_TODOS_TOOL_NAME, WEB_FETCH_TOOL_NAME, READ_MANY_FILES_TOOL_NAME, MEMORY_TOOL_NAME, GET_INTERNAL_DOCS_TOOL_NAME, ACTIVATE_SKILL_TOOL_NAME, ASK_USER_TOOL_NAME, EXIT_PLAN_MODE_TOOL_NAME, ENTER_PLAN_MODE_TOOL_NAME, } from './base-declarations.js';
export { DEFAULT_LEGACY_SET } from './model-family-sets/default-legacy.js';
export { GEMINI_3_SET } from './model-family-sets/gemini-3.js';
/**
 * Resolves the appropriate tool set for a given model ID.
 */
export declare function getToolSet(modelId?: string): CoreToolSet;
export declare const READ_FILE_DEFINITION: ToolDefinition;
export declare const WRITE_FILE_DEFINITION: ToolDefinition;
export declare const GREP_DEFINITION: ToolDefinition;
export declare const RIP_GREP_DEFINITION: ToolDefinition;
export declare const WEB_SEARCH_DEFINITION: ToolDefinition;
export declare const EDIT_DEFINITION: ToolDefinition;
export declare const GLOB_DEFINITION: ToolDefinition;
export declare const LS_DEFINITION: ToolDefinition;
export declare const WEB_FETCH_DEFINITION: ToolDefinition;
export declare const READ_MANY_FILES_DEFINITION: ToolDefinition;
export declare const MEMORY_DEFINITION: ToolDefinition;
export declare const WRITE_TODOS_DEFINITION: ToolDefinition;
export declare const GET_INTERNAL_DOCS_DEFINITION: ToolDefinition;
export declare const ASK_USER_DEFINITION: ToolDefinition;
export declare const ENTER_PLAN_MODE_DEFINITION: ToolDefinition;
export { getShellToolDescription, getCommandDescription, } from './dynamic-declaration-helpers.js';
export declare function getShellDefinition(enableInteractiveShell: boolean, enableEfficiency: boolean): ToolDefinition;
export declare function getExitPlanModeDefinition(plansDir: string): ToolDefinition;
export declare function getActivateSkillDefinition(skillNames: string[]): ToolDefinition;
