# Gemini CLI: License, Terms of Service, and Privacy Notices

Gemini CLI is an open-source tool that lets you interact with Google's powerful
AI services directly from your command-line interface. The Gemini CLI software
is licensed under the
[Apache 2.0 license](https://github.com/google-gemini/gemini-cli/blob/main/LICENSE).
When you use Gemini CLI to access or use Google’s services, the Terms of Service
and Privacy Notices applicable to those services apply to such access and use.

Your Gemini CLI Usage Statistics are handled in accordance with Google's Privacy
Policy.

**Note:** See [quotas and pricing](/docs/resources/quota-and-pricing.md) for the
quota and pricing details that apply to your usage of the Gemini CLI.

## Supported authentication methods

Your authentication method refers to the method you use to log into and access
Google’s services with Gemini CLI. Supported authentication methods include:

- Logging in with your Google account to Gemini Code Assist.
- Using an API key with Gemini Developer API.
- Using an API key with Vertex AI GenAI API.

The Terms of Service and Privacy Notices applicable to the aforementioned Google
services are set forth in the table below.

If you log in with your Google account and you do not already have a Gemini Code
Assist account associated with your Google account, you will be directed to the
sign up flow for Gemini Code Assist for individuals. If your Google account is
managed by your organization, your administrator may not permit access to Gemini
Code Assist for individuals. Please see the
[Gemini Code Assist for individuals FAQs](https://developers.google.com/gemini-code-assist/resources/faqs)
for further information.

| Authentication Method    | Service(s)                   | Terms of Service                                                                                        | Privacy Notice                                                                                |
| :----------------------- | :--------------------------- | :------------------------------------------------------------------------------------------------------ | :-------------------------------------------------------------------------------------------- |
| Google Account           | Gemini Code Assist services  | [Terms of Service](https://developers.google.com/gemini-code-assist/resources/privacy-notices)          | [Privacy Notices](https://developers.google.com/gemini-code-assist/resources/privacy-notices) |
| Gemini Developer API Key | Gemini API - Unpaid Services | [Gemini API Terms of Service - Unpaid Services](https://ai.google.dev/gemini-api/terms#unpaid-services) | [Google Privacy Policy](https://policies.google.com/privacy)                                  |
| Gemini Developer API Key | Gemini API - Paid Services   | [Gemini API Terms of Service - Paid Services](https://ai.google.dev/gemini-api/terms#paid-services)     | [Google Privacy Policy](https://policies.google.com/privacy)                                  |
| Vertex AI GenAI API Key  | Vertex AI GenAI API          | [Google Cloud Platform Terms of Service](https://cloud.google.com/terms/service-terms/)                 | [Google Cloud Privacy Notice](https://cloud.google.com/terms/cloud-privacy-notice)            |

## 1. If you have logged in with your Google account to Gemini Code Assist

For users who use their Google account to access
[Gemini Code Assist](https://codeassist.google), these Terms of Service and
Privacy Notice documents apply:

- Gemini Code Assist for individuals:
  [Google Terms of Service](https://policies.google.com/terms) and
  [Gemini Code Assist for individuals Privacy Notice](https://developers.google.com/gemini-code-assist/resources/privacy-notice-gemini-code-assist-individuals).
- Gemini Code Assist with Google AI Pro or Ultra subscription:
  [Google Terms of Service](https://policies.google.com/terms),
  [Google One Additional Terms of Service](https://one.google.com/terms-of-service)
  and [Google Privacy Policy\*](https://policies.google.com/privacy).
- Gemini Code Assist Standard and Enterprise editions:
  [Google Cloud Platform Terms of Service](https://cloud.google.com/terms) and
  [Google Cloud Privacy Notice](https://cloud.google.com/terms/cloud-privacy-notice).

_\* If your account is also associated with an active subscription to Gemini
Code Assist Standard or Enterprise edition, the terms and privacy policy of
Gemini Code Assist Standard or Enterprise edition will apply to all your use of
Gemini Code Assist._

## 2. If you have logged in with a Gemini API key to the Gemini Developer API

If you are using a Gemini API key for authentication with the
[Gemini Developer API](https://ai.google.dev/gemini-api/docs), these Terms of
Service and Privacy Notice documents apply:

- Terms of Service: Your use of the Gemini CLI is governed by the
  [Gemini API Terms of Service](https://ai.google.dev/gemini-api/terms). These
  terms may differ depending on whether you are using an unpaid or paid service:
  - For unpaid services, refer to the
    [Gemini API Terms of Service - Unpaid Services](https://ai.google.dev/gemini-api/terms#unpaid-services).
  - For paid services, refer to the
    [Gemini API Terms of Service - Paid Services](https://ai.google.dev/gemini-api/terms#paid-services).
- Privacy Notice: The collection and use of your data is described in the
  [Google Privacy Policy](https://policies.google.com/privacy).

## 3. If you have logged in with a Gemini API key to the Vertex AI GenAI API

If you are using a Gemini API key for authentication with a
[Vertex AI GenAI API](https://cloud.google.com/vertex-ai/generative-ai/docs/reference/rest)
backend, these Terms of Service and Privacy Notice documents apply:

- Terms of Service: Your use of the Gemini CLI is governed by the
  [Google Cloud Platform Service Terms](https://cloud.google.com/terms/service-terms/).
- Privacy Notice: The collection and use of your data is described in the
  [Google Cloud Privacy Notice](https://cloud.google.com/terms/cloud-privacy-notice).

## Usage statistics opt-out

You may opt-out from sending Gemini CLI Usage Statistics to Google by following
the instructions available here:
[Usage Statistics Configuration](https://github.com/google-gemini/gemini-cli/blob/main/docs/reference/configuration.md#usage-statistics).
