/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Details about a deceptive URL.
 */
export interface DeceptiveUrlDetails {
    /** The Unicode version of the visually deceptive URL. */
    originalUrl: string;
    /** The ASCII-safe Punycode version of the URL. */
    punycodeUrl: string;
}
/**
 * Converts a URL (string or object) to its visually deceptive Unicode version.
 *
 * This function manually reconstructs the URL to bypass the automatic Punycode
 * conversion performed by the WHATWG URL class when setting the hostname.
 *
 * @param urlInput The URL string or URL object to convert.
 * @returns The reconstructed URL string with the hostname in Unicode.
 */
export declare function toUnicodeUrl(urlInput: string | URL): string;
/**
 * Extracts deceptive URL details if a URL hostname contains non-ASCII characters
 * or is already in Punycode.
 *
 * @param urlString The URL string to check.
 * @returns DeceptiveUrlDetails if a potential deceptive URL is detected, otherwise null.
 */
export declare function getDeceptiveUrlDetails(urlString: string): DeceptiveUrlDetails | null;
