/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Creates a UI context object with no-op functions.
 * Useful for non-interactive environments where UI operations
 * are not applicable.
 */
export function createNonInteractiveUI() {
    return {
        addItem: (item, _timestamp) => {
            if ('text' in item && item.text) {
                if (item.type === 'error') {
                    process.stderr.write(`Error: ${item.text}\n`);
                }
                else if (item.type === 'warning') {
                    process.stderr.write(`Warning: ${item.text}\n`);
                }
                else if (item.type === 'info') {
                    process.stdout.write(`${item.text}\n`);
                }
            }
            return 0;
        },
        clear: () => { },
        setDebugMessage: (_message) => { },
        loadHistory: (_newHistory) => { },
        pendingItem: null,
        setPendingItem: (_item) => { },
        toggleCorgiMode: () => { },
        toggleDebugProfiler: () => { },
        toggleVimEnabled: async () => false,
        reloadCommands: () => { },
        openAgentConfigDialog: () => { },
        extensionsUpdateState: new Map(),
        dispatchExtensionStateUpdate: (_action) => { },
        addConfirmUpdateExtensionRequest: (_request) => { },
        setConfirmationRequest: (_request) => { },
        removeComponent: () => { },
        toggleBackgroundShell: () => { },
        toggleShortcutsHelp: () => { },
    };
}
//# sourceMappingURL=nonInteractiveUi.js.map