/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { StreamingState, type ConfirmationRequest, type HistoryItemWithoutId, type PermissionConfirmationRequest } from '../types.js';
interface RunEventNotificationParams {
    notificationsEnabled: boolean;
    isFocused: boolean;
    hasReceivedFocusEvent: boolean;
    streamingState: StreamingState;
    hasPendingActionRequired: boolean;
    pendingHistoryItems: HistoryItemWithoutId[];
    commandConfirmationRequest: ConfirmationRequest | null;
    authConsentRequest: ConfirmationRequest | null;
    permissionConfirmationRequest: PermissionConfirmationRequest | null;
    hasConfirmUpdateExtensionRequests: boolean;
    hasLoopDetectionConfirmationRequest: boolean;
    terminalName?: string;
}
export declare function useRunEventNotifications({ notificationsEnabled, isFocused, hasReceivedFocusEvent, streamingState, hasPendingActionRequired, pendingHistoryItems, commandConfirmationRequest, authConsentRequest, permissionConfirmationRequest, hasConfirmUpdateExtensionRequests, hasLoopDetectionConfirmationRequest, }: RunEventNotificationParams): void;
export {};
