/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { useState, useEffect, useRef } from 'react';
import { useSearchBuffer } from './useSearchBuffer.js';
export function useRegistrySearch(props) {
    const { items, initialQuery = '', onSearch } = props;
    const [searchQuery, setSearchQuery] = useState(initialQuery);
    const isFirstRender = useRef(true);
    const onSearchRef = useRef(onSearch);
    onSearchRef.current = onSearch;
    useEffect(() => {
        if (isFirstRender.current) {
            isFirstRender.current = false;
            return;
        }
        onSearchRef.current?.(searchQuery);
    }, [searchQuery]);
    const searchBuffer = useSearchBuffer({
        initialText: searchQuery,
        onChange: setSearchQuery,
    });
    const maxLabelWidth = 0;
    const filteredItems = items;
    return {
        filteredItems,
        searchBuffer,
        searchQuery,
        setSearchQuery,
        maxLabelWidth,
    };
}
//# sourceMappingURL=useRegistrySearch.js.map