/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import type { LoadedSettings } from '../../config/settings.js';
import { FolderTrustChoice } from '../components/FolderTrustDialog.js';
import { type HistoryItemWithoutId } from '../types.js';
import { type FolderDiscoveryResults } from '@google/gemini-cli-core';
export declare const useFolderTrust: (settings: LoadedSettings, onTrustChange: (isTrusted: boolean | undefined) => void, addItem: (item: HistoryItemWithoutId, timestamp: number) => number) => {
    isTrusted: boolean | undefined;
    isFolderTrustDialogOpen: boolean;
    discoveryResults: FolderDiscoveryResults | null;
    handleFolderTrustSelect: (choice: FolderTrustChoice) => Promise<void>;
    isRestarting: boolean;
};
