import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useMemo, useCallback } from 'react';
import { Box, Text } from 'ink';
import { SearchableList, } from '../shared/SearchableList.js';
import { theme } from '../../semantic-colors.js';
import { useExtensionRegistry } from '../../hooks/useExtensionRegistry.js';
import { ExtensionUpdateState } from '../../state/extensions.js';
import { useExtensionUpdates } from '../../hooks/useExtensionUpdates.js';
import { useConfig } from '../../contexts/ConfigContext.js';
import { useRegistrySearch } from '../../hooks/useRegistrySearch.js';
import { useUIState } from '../../contexts/UIStateContext.js';
export function ExtensionRegistryView({ onSelect, onClose, extensionManager, }) {
    const { extensions, loading, error, search } = useExtensionRegistry();
    const config = useConfig();
    const { terminalHeight, staticExtraHeight } = useUIState();
    const { extensionsUpdateState } = useExtensionUpdates(extensionManager, () => 0, config.getEnableExtensionReloading());
    const installedExtensions = extensionManager.getExtensions();
    const items = useMemo(() => extensions.map((ext) => ({
        key: ext.id,
        label: ext.extensionName,
        description: ext.extensionDescription || ext.repoDescription,
        extension: ext,
    })), [extensions]);
    const handleSelect = useCallback((item) => {
        onSelect?.(item.extension);
    }, [onSelect]);
    const renderItem = useCallback((item, isActive, _labelWidth) => {
        const isInstalled = installedExtensions.some((e) => e.name === item.extension.extensionName);
        const updateState = extensionsUpdateState.get(item.extension.extensionName);
        const hasUpdate = updateState === ExtensionUpdateState.UPDATE_AVAILABLE;
        return (_jsxs(Box, { flexDirection: "row", width: "100%", justifyContent: "space-between", children: [_jsxs(Box, { flexDirection: "row", flexShrink: 1, minWidth: 0, children: [_jsx(Box, { width: 2, flexShrink: 0, children: _jsx(Text, { color: isActive ? theme.status.success : theme.text.secondary, children: isActive ? '● ' : '  ' }) }), _jsx(Box, { flexShrink: 0, children: _jsx(Text, { bold: isActive, color: isActive ? theme.status.success : theme.text.primary, children: item.label }) }), _jsx(Box, { flexShrink: 0, marginX: 1, children: _jsx(Text, { color: theme.text.secondary, children: "|" }) }), isInstalled && (_jsx(Box, { marginRight: 1, flexShrink: 0, children: _jsx(Text, { color: theme.status.success, children: "[Installed]" }) })), hasUpdate && (_jsx(Box, { marginRight: 1, flexShrink: 0, children: _jsx(Text, { color: theme.status.warning, children: "[Update available]" }) })), _jsx(Box, { flexShrink: 1, minWidth: 0, children: _jsx(Text, { color: theme.text.secondary, wrap: "truncate-end", children: item.description }) })] }), _jsxs(Box, { flexShrink: 0, marginLeft: 2, width: 8, flexDirection: "row", children: [_jsx(Text, { color: theme.status.warning, children: "\u2B50" }), _jsxs(Text, { color: isActive ? theme.status.success : theme.text.secondary, children: [' ', item.extension.stars || 0] })] })] }));
    }, [installedExtensions, extensionsUpdateState]);
    const header = useMemo(() => (_jsxs(Box, { flexDirection: "row", justifyContent: "space-between", width: "100%", children: [_jsx(Box, { flexShrink: 1, children: _jsx(Text, { color: theme.text.secondary, wrap: "truncate", children: "Browse and search extensions from the registry." }) }), _jsx(Box, { flexShrink: 0, marginLeft: 2, children: _jsx(Text, { color: theme.text.secondary, children: installedExtensions.length &&
                        `${installedExtensions.length} installed` }) })] })), [installedExtensions.length]);
    const footer = useCallback(({ startIndex, endIndex, totalVisible, }) => (_jsxs(Text, { color: theme.text.secondary, children: ["(", startIndex + 1, "-", endIndex, ") / ", totalVisible] })), []);
    const maxItemsToShow = useMemo(() => {
        // SearchableList layout overhead:
        // Container paddingY: 0
        // Title (marginBottom 1): 2
        // Search buffer (border 2, marginBottom 1): 4
        // Header (marginBottom 1): 2
        // Footer (marginTop 1): 2
        // List item (marginBottom 1): 2 per item
        // Total static height = 2 + 4 + 2 + 2 = 10
        const staticHeight = 10;
        const availableTerminalHeight = terminalHeight - staticExtraHeight;
        const remainingHeight = Math.max(0, availableTerminalHeight - staticHeight);
        const itemHeight = 2; // Each item takes 2 lines (content + marginBottom 1)
        // Ensure we show at least a few items and not more than we have
        return Math.max(4, Math.floor(remainingHeight / itemHeight));
    }, [terminalHeight, staticExtraHeight]);
    if (loading) {
        return (_jsx(Box, { padding: 1, children: _jsx(Text, { color: theme.text.secondary, children: "Loading extensions..." }) }));
    }
    if (error) {
        return (_jsxs(Box, { padding: 1, flexDirection: "column", children: [_jsx(Text, { color: theme.status.error, children: "Error loading extensions:" }), _jsx(Text, { color: theme.text.secondary, children: error })] }));
    }
    return (_jsx(SearchableList, { title: "Extensions", items: items, onSelect: handleSelect, onClose: onClose || (() => { }), searchPlaceholder: "Search extension gallery", renderItem: renderItem, header: header, footer: footer, maxItemsToShow: maxItemsToShow, useSearch: useRegistrySearch, onSearch: search, resetSelectionOnItemsChange: true }));
}
//# sourceMappingURL=ExtensionRegistryView.js.map