import { jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { describe, it, expect } from 'vitest';
import { renderWithProviders } from '../../../test-utils/render.js';
import { ThinkingMessage } from './ThinkingMessage.js';
describe('ThinkingMessage', () => {
    it('renders subject line', async () => {
        const { lastFrame, waitUntilReady, unmount } = renderWithProviders(_jsx(ThinkingMessage, { thought: { subject: 'Planning', description: 'test' } }));
        await waitUntilReady();
        expect(lastFrame()).toMatchSnapshot();
        unmount();
    });
    it('uses description when subject is empty', async () => {
        const { lastFrame, waitUntilReady, unmount } = renderWithProviders(_jsx(ThinkingMessage, { thought: { subject: '', description: 'Processing details' } }));
        await waitUntilReady();
        expect(lastFrame()).toMatchSnapshot();
        unmount();
    });
    it('renders full mode with left border and full text', async () => {
        const { lastFrame, waitUntilReady, unmount } = renderWithProviders(_jsx(ThinkingMessage, { thought: {
                subject: 'Planning',
                description: 'I am planning the solution.',
            } }));
        await waitUntilReady();
        expect(lastFrame()).toMatchSnapshot();
        unmount();
    });
    it('indents summary line correctly', async () => {
        const { lastFrame, waitUntilReady, unmount } = renderWithProviders(_jsx(ThinkingMessage, { thought: {
                subject: 'Summary line',
                description: 'First body line',
            } }));
        await waitUntilReady();
        expect(lastFrame()).toMatchSnapshot();
        unmount();
    });
    it('normalizes escaped newline tokens', async () => {
        const { lastFrame, waitUntilReady, unmount } = renderWithProviders(_jsx(ThinkingMessage, { thought: {
                subject: 'Matching the Blocks',
                description: '\\n\\nSome more text',
            } }));
        await waitUntilReady();
        expect(lastFrame()).toMatchSnapshot();
        unmount();
    });
    it('renders empty state gracefully', async () => {
        const { lastFrame, waitUntilReady, unmount } = renderWithProviders(_jsx(ThinkingMessage, { thought: { subject: '', description: '' } }));
        await waitUntilReady();
        expect(lastFrame({ allowEmpty: true })).toBe('');
        unmount();
    });
});
//# sourceMappingURL=ThinkingMessage.test.js.map