import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Text, Box } from 'ink';
import { theme } from '../../semantic-colors.js';
import { SCREEN_READER_USER_PREFIX } from '../../textConstants.js';
import { HalfLinePaddedBox } from '../shared/HalfLinePaddedBox.js';
import { useConfig } from '../../contexts/ConfigContext.js';
export const HintMessage = ({ text }) => {
    const prefix = '💡 ';
    const prefixWidth = prefix.length;
    const config = useConfig();
    const useBackgroundColor = config.getUseBackgroundColor();
    return (_jsx(HalfLinePaddedBox, { backgroundBaseColor: theme.text.accent, backgroundOpacity: 0.1, useBackgroundColor: useBackgroundColor, children: _jsxs(Box, { flexDirection: "row", paddingY: 0, marginY: useBackgroundColor ? 0 : 1, paddingX: useBackgroundColor ? 1 : 0, alignSelf: "flex-start", children: [_jsx(Box, { width: prefixWidth, flexShrink: 0, children: _jsx(Text, { color: theme.text.accent, "aria-label": SCREEN_READER_USER_PREFIX, children: prefix }) }), _jsx(Box, { flexGrow: 1, children: _jsx(Text, { wrap: "wrap", italic: true, color: theme.text.accent, children: `Steering Hint: ${text}` }) })] }) }));
};
//# sourceMappingURL=HintMessage.js.map