import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Text } from 'ink';
import { theme } from '../semantic-colors.js';
import { isNarrowWidth } from '../utils/isNarrowWidth.js';
import { SectionHeader } from './shared/SectionHeader.js';
import { useUIState } from '../contexts/UIStateContext.js';
const buildShortcutItems = () => {
    const isMac = process.platform === 'darwin';
    const altLabel = isMac ? 'Option' : 'Alt';
    return [
        { key: '!', description: 'shell mode' },
        { key: '@', description: 'select file or folder' },
        { key: 'Esc Esc', description: 'clear & rewind' },
        { key: 'Tab Tab', description: 'focus UI' },
        { key: 'Ctrl+Y', description: 'YOLO mode' },
        { key: 'Shift+Tab', description: 'cycle mode' },
        { key: 'Ctrl+V', description: 'paste images' },
        { key: `${altLabel}+M`, description: 'raw markdown mode' },
        { key: 'Ctrl+R', description: 'reverse-search history' },
        { key: 'Ctrl+X', description: 'open external editor' },
    ];
};
const Shortcut = ({ item }) => (_jsxs(Box, { flexDirection: "row", children: [_jsx(Box, { flexShrink: 0, marginRight: 1, children: _jsx(Text, { color: theme.text.accent, children: item.key }) }), _jsx(Box, { flexGrow: 1, children: _jsx(Text, { color: theme.text.primary, children: item.description }) })] }));
export const ShortcutsHelp = () => {
    const { terminalWidth } = useUIState();
    const isNarrow = isNarrowWidth(terminalWidth);
    const items = buildShortcutItems();
    const itemsForDisplay = isNarrow
        ? items
        : [
            // Keep first column stable: !, @, Esc Esc, Tab Tab.
            items[0],
            items[5],
            items[6],
            items[1],
            items[4],
            items[7],
            items[2],
            items[8],
            items[9],
            items[3],
        ];
    return (_jsxs(Box, { flexDirection: "column", width: "100%", children: [_jsx(SectionHeader, { title: " Shortcuts", subtitle: " See /help for more" }), _jsx(Box, { flexDirection: "row", flexWrap: "wrap", paddingLeft: 1, paddingRight: 2, children: itemsForDisplay.map((item, index) => (_jsx(Box, { width: isNarrow ? '100%' : '33%', paddingRight: isNarrow ? 0 : 2, children: _jsx(Shortcut, { item: item }) }, `${item.key}-${index}`))) })] }));
};
//# sourceMappingURL=ShortcutsHelp.js.map