import { jsxs as _jsxs, jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { Box, Text } from 'ink';
import { useCallback, useRef } from 'react';
import { PolicyIntegrityManager, } from '@google/gemini-cli-core';
import { theme } from '../semantic-colors.js';
import { RadioButtonSelect } from './shared/RadioButtonSelect.js';
import { useKeypress } from '../hooks/useKeypress.js';
import { keyMatchers, Command } from '../keyMatchers.js';
export var PolicyUpdateChoice;
(function (PolicyUpdateChoice) {
    PolicyUpdateChoice["ACCEPT"] = "accept";
    PolicyUpdateChoice["IGNORE"] = "ignore";
})(PolicyUpdateChoice || (PolicyUpdateChoice = {}));
export const PolicyUpdateDialog = ({ config, request, onClose, }) => {
    const isProcessing = useRef(false);
    const handleSelect = useCallback(async (choice) => {
        if (isProcessing.current) {
            return;
        }
        isProcessing.current = true;
        try {
            if (choice === PolicyUpdateChoice.ACCEPT) {
                const integrityManager = new PolicyIntegrityManager();
                await integrityManager.acceptIntegrity(request.scope, request.identifier, request.newHash);
                await config.loadWorkspacePolicies(request.policyDir);
            }
            onClose();
        }
        finally {
            isProcessing.current = false;
        }
    }, [config, request, onClose]);
    useKeypress((key) => {
        if (keyMatchers[Command.ESCAPE](key)) {
            onClose();
            return true;
        }
        return false;
    }, { isActive: true });
    const options = [
        {
            label: 'Accept and Load',
            value: PolicyUpdateChoice.ACCEPT,
            key: 'accept',
        },
        {
            label: 'Ignore (Use Default Policies)',
            value: PolicyUpdateChoice.IGNORE,
            key: 'ignore',
        },
    ];
    return (_jsx(Box, { flexDirection: "column", width: "100%", children: _jsxs(Box, { flexDirection: "column", borderStyle: "round", borderColor: theme.status.warning, padding: 1, marginLeft: 1, marginRight: 1, children: [_jsxs(Box, { flexDirection: "column", marginBottom: 1, children: [_jsxs(Text, { bold: true, color: theme.text.primary, children: ["New or changed ", request.scope, " policies detected"] }), _jsxs(Text, { color: theme.text.primary, children: ["Location: ", request.identifier] }), _jsx(Text, { color: theme.text.primary, children: "Do you want to accept and load these policies?" })] }), _jsx(RadioButtonSelect, { items: options, onSelect: handleSelect, isFocused: true })] }) }));
};
//# sourceMappingURL=PolicyUpdateDialog.js.map