import { jsx as _jsx } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { render } from '../../test-utils/render.js';
import { describe, it, expect } from 'vitest';
import { ChecklistItem } from './ChecklistItem.js';
import { Box } from 'ink';
describe('<ChecklistItem />', () => {
    it.each([
        { status: 'pending', label: 'Do this' },
        { status: 'in_progress', label: 'Doing this' },
        { status: 'completed', label: 'Done this' },
        { status: 'cancelled', label: 'Skipped this' },
    ])('renders %s item correctly', async (item) => {
        const { lastFrame, waitUntilReady } = render(_jsx(ChecklistItem, { item: item }));
        await waitUntilReady();
        expect(lastFrame()).toMatchSnapshot();
    });
    it('truncates long text when wrap="truncate"', async () => {
        const item = {
            status: 'in_progress',
            label: 'This is a very long text that should be truncated because the wrap prop is set to truncate',
        };
        const { lastFrame, waitUntilReady } = render(_jsx(Box, { width: 30, children: _jsx(ChecklistItem, { item: item, wrap: "truncate" }) }));
        await waitUntilReady();
        expect(lastFrame()).toMatchSnapshot();
    });
    it('wraps long text by default', async () => {
        const item = {
            status: 'in_progress',
            label: 'This is a very long text that should wrap because the default behavior is wrapping',
        };
        const { lastFrame, waitUntilReady } = render(_jsx(Box, { width: 30, children: _jsx(ChecklistItem, { item: item }) }));
        await waitUntilReady();
        expect(lastFrame()).toMatchSnapshot();
    });
});
//# sourceMappingURL=ChecklistItem.test.js.map