/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type PolicyEngineConfig, type ApprovalMode, type PolicyEngine, type MessageBus, Storage, type PolicyUpdateConfirmationRequest } from '@google/gemini-cli-core';
import { type Settings } from './settings.js';
/**
 * Temporary flag to automatically accept workspace policies to reduce friction.
 * Exported as 'let' to allow monkey patching in tests via the setter.
 */
export declare let autoAcceptWorkspacePolicies: boolean;
/**
 * Sets the autoAcceptWorkspacePolicies flag.
 * Used primarily for testing purposes.
 */
export declare function setAutoAcceptWorkspacePolicies(value: boolean): void;
/**
 * Temporary flag to disable workspace level policies altogether.
 * Exported as 'let' to allow monkey patching in tests via the setter.
 */
export declare let disableWorkspacePolicies: boolean;
/**
 * Sets the disableWorkspacePolicies flag.
 * Used primarily for testing purposes.
 */
export declare function setDisableWorkspacePolicies(value: boolean): void;
export declare function createPolicyEngineConfig(settings: Settings, approvalMode: ApprovalMode, workspacePoliciesDir?: string): Promise<PolicyEngineConfig>;
export declare function createPolicyUpdater(policyEngine: PolicyEngine, messageBus: MessageBus, storage: Storage): void;
export interface WorkspacePolicyState {
    workspacePoliciesDir?: string;
    policyUpdateConfirmationRequest?: PolicyUpdateConfirmationRequest;
}
/**
 * Resolves the workspace policy state by checking folder trust and policy integrity.
 */
export declare function resolveWorkspacePolicyState(options: {
    cwd: string;
    trustedFolder: boolean;
    interactive: boolean;
}): Promise<WorkspacePolicyState>;
