'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

function flow(...funcs) {
    return function (...args) {
        let result = funcs.length ? funcs[0].apply(this, args) : args[0];
        for (let i = 1; i < funcs.length; i++) {
            result = funcs[i].call(this, result);
        }
        return result;
    };
}

exports.flow = flow;
