"use strict";
/*
 * Copyright The OpenTelemetry Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.defaultServiceName = void 0;
// Check if we are in a Node.js environment and if so, use the process.argv0 property
// to determine the default service name
const DEFAULT_SERVICE_NAME = typeof process === 'object' &&
    typeof process.argv0 === 'string' &&
    process.argv0.length > 0
    ? `unknown_service:${process.argv0}`
    : 'unknown_service';
function defaultServiceName() {
    return DEFAULT_SERVICE_NAME;
}
exports.defaultServiceName = defaultServiceName;
//# sourceMappingURL=default-service-name.js.map