// The example class categories definitions for Doxygen

/// \file Doxymodules_medical.h
/// \brief The page that defines the extended/medical examples modules 


/** @defgroup extended_medical medical
 *  Extended medical examples classes
 *  @{
 */

/** @defgroup extended_medical_DICOM DICOM
 *  Medical example DICOM 
 *  @ingroup extended_medical
 *  @{
 */

  class DicomActionInitialization {};
  class DicomDetectorConstruction {};
  class DicomEventAction {};
  class DicomHandler {};
  class DicomIntersectVolume {};
  class DicomNestedParamDetectorConstruction {};
  class DicomNestedPhantomParameterisation {};
  class DicomPartialDetectorConstruction {};
  class DicomPhantomParameterisationColour {};
  class DicomPhantomZSliceHeader {};
  class DicomPhantomZSliceMerged {};
  class DicomPrimaryGeneratorAction {};
  class DicomRegularDetectorConstruction {};
  class DicomRunAction {};
  class DicomRun {};  

/** @defgroup extended_medical_DICOM_dicomReader dicomReader
 *  dicomReader in medical example DICOM
 *  @ingroup extended_medical_DICOM
 *  @{
 */

  class DicomBeam {};
  class DicomBeamBlock {};
  class DicomBeamCompensator {};
  class DicomBeamControlPoint {};
  class DicomBeamDevice {};
  class DicomBeamDevicePos {};
  class DicomBeamDeviceRef {};
  class DicomBeamWedge {};
  class DicomFileCT {};
  class DicomFileCT_NOdcmrt {};
  class DicomFileMgr {};
  class DicomFilePET {};
  class DicomFilePlan {};
  class DicomFileStructure {};
  class DicomROI {};
  class DicomROIContour {};
  class DicomVBeamDevice {};
  class DicomVFile {};
  class DicomVFileImage {};

/** @} */

/** @} */

/** @defgroup extended_medical_DICOM2 DICOM2
 *  Medical example DICOM2
 *  @ingroup extended_medical
 *  @{
 */

  class Dicom2ActionInitialization {};
  class Dicom2PrimaryGeneratorAction {};

/** @} */

/** @defgroup extended_medical_electronScattering electronScattering
 *  Medical electronScattering example has its
 *  <a href="../html_electronScattering/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical
 *  @{
 */

/** @} */

/** @defgroup extended_medical_electronScattering2 electronScattering2
 *  Medical electronScattering2 example has its
 *  <a href="../html_electronScattering2/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical
 *  @{
 */

/** @} */

/** @defgroup extended_medical_fanoCavity fanoCavity
 *  Medical fanoCavity example has its
 *  <a href="../html_fanoCavity/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical
 *  @{
 */

/** @} */

/** @defgroup extended_medical_fanoCavity2 fanoCavity2
 *  Medical fanoCavity2 example has its
 *  <a href="../html_fanoCavity2/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical
 *  @{
 */

/** @} */

/** @defgroup extended_medical_GammaTherapy GammaTherapy
 *  Medical GammaTherapy example has its
 *  <a href="../html_GammaTherapy/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna dna
 *  Extended examples medical dna classes
 *  @{
 */

/** @defgroup extended_medical_dna_chem1 chem1
 *  Medical dna chem1 example has its
 *  <a href="../html_chem1/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_chem2 chem2
 *  Medical dna chem2 example has its
 *  <a href="../html_chem2/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_chem3 chem3
 *  Medical dna chem3 example has its
 *  <a href="../html_chem3/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_chem4 chem4
 *  Medical dna chem4 example has its
 *  <a href="../html_chem4/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_chem5 chem5
 *  Medical dna chem5 example has its
 *  <a href="../html_chem5/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_clustering clustering
 *  Medical dna clustering example has its
 *  <a href="../html_clustering/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_dnadamage1 dnadamage1
 *  Medical dna dnadamage1 example has its
 *  <a href="../html_dnadamage1/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_dnaphysics dnaphysics
 *  Medical dna dnaphysics example has its
 *  <a href="../html_dnaphysics/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_icsd icsd
 *  Medical dna icsd example has its
 *  <a href="../html_icsd/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_mfp mfp
 *  Medical dna mfp example has its
 *  <a href="../html_mfp/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_microdosimetry microdosimetry
 *  Medical dna microdosimetry example has its
 *  <a href="../html_microdosimetry/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_microprox microprox
 *  Medical dna microprox example has its
 *  <a href="../html_microprox/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_microyz microyz
 *  Medical dna microyz example has its
 *  <a href="../html_microyz/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_neuron neuron
 *  Medical dna neuron example has its
 *  <a href="../html_neuron/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_pdb4dna pdb4dna
 *  Medical dna pdb4dna example has its
 *  <a href="../html_pdb4dna/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_range range
 *  Medical dna range example has its
 *  <a href="../html_range/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_slowing slowing
 *  Medical dna slowing example has its
 *  <a href="../html_slowing/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_splitting splitting
 *  Medical dna splitting example has its
 *  <a href="../html_splitting/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_spower spower
 *  Medical dna spower example has its
 *  <a href="../html_spower/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_svalue svalue
 *  Medical dna svalue example has its
 *  <a href="../html_svalue/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_wholeNuclearDNA wholeNuclearDNA
 *  Medical dna wholeNuclearDNA example has its
 *  <a href="../html_wholeNuclearDNA/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @defgroup extended_medical_dna_wvalue wvalue
 *  Medical dna wvalue example has its
 *  <a href="../html_wvalue/html/index.html">standalone documentation </a>
 *  @ingroup extended_medical_dna
 *  @{
 */

/** @} */

/** @} */

/** @} */
