/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.xmlschema;

import gnu.xml.validation.datatype.Annotation;
import gnu.xml.validation.datatype.SimpleType;
import gnu.xml.validation.datatype.Type;
import gnu.xml.validation.xmlschema.AnyAttribute;
import gnu.xml.validation.xmlschema.AttributeDeclaration;
import gnu.xml.validation.xmlschema.AttributeUse;
import gnu.xml.validation.xmlschema.ComplexType;
import gnu.xml.validation.xmlschema.ElementDeclaration;
import gnu.xml.validation.xmlschema.Particle;
import gnu.xml.validation.xmlschema.XMLSchema;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class XMLSchemaBuilder {
    XMLSchema schema;
    final DatatypeLibrary typeLibrary = new DatatypeLibraryLoader().createDatatypeLibrary("http://www.w3.org/2001/XMLSchema");

    XMLSchemaBuilder() {
    }

    void parseSchema(Node node2) throws DatatypeException {
        String uri = node2.getNamespaceURI();
        String name = node2.getLocalName();
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && node2.getNodeType() == 1 && "schema".equals(name)) {
            NamedNodeMap attrs = node2.getAttributes();
            String targetNamespace = XMLSchemaBuilder.getAttribute(attrs, "targetNamespace");
            String version = XMLSchemaBuilder.getAttribute(attrs, "version");
            String fd = XMLSchemaBuilder.getAttribute(attrs, "finalDefault");
            int finalDefault = this.parseFullDerivationSet(fd);
            String bd = XMLSchemaBuilder.getAttribute(attrs, "blockDefault");
            int blockDefault = this.parseBlockSet(bd);
            String afd = XMLSchemaBuilder.getAttribute(attrs, "attributeFormDefault");
            boolean attributeFormQualified = "qualified".equals(afd);
            String efd = XMLSchemaBuilder.getAttribute(attrs, "elementFormDefault");
            boolean elementFormQualified = "qualified".equals(efd);
            this.schema = new XMLSchema(targetNamespace, version, finalDefault, blockDefault, attributeFormQualified, elementFormQualified);
            Node child = node2.getFirstChild();
            while (child != null) {
                this.parseTopLevelElement(child);
                child = child.getNextSibling();
            }
            return;
        }
    }

    void parseTopLevelElement(Node node2) throws DatatypeException {
        String uri = node2.getNamespaceURI();
        String name = node2.getLocalName();
        if ("http://www.w3.org/2001/XMLSchema".equals(uri) && node2.getNodeType() == 1) {
            if ("element".equals(name)) {
                ElementDeclaration ed = (ElementDeclaration)this.parseElement(node2, null);
                this.schema.elementDeclarations.put(ed.name, ed);
            } else if ("attribute".equals(name)) {
                AttributeDeclaration ad = (AttributeDeclaration)this.parseAttribute(node2, true);
                this.schema.attributeDeclarations.put(ad.name, ad);
            } else if (!("type".equals(name) || "group".equals(name) || "attributeGroup".equals(name) || "notation".equals(name))) {
                "identityConstraint".equals(name);
            }
        }
    }

    Object parseAttribute(Node node2, boolean scope) throws DatatypeException {
        NamedNodeMap attrs = node2.getAttributes();
        String def = XMLSchemaBuilder.getAttribute(attrs, "default");
        String fixed = XMLSchemaBuilder.getAttribute(attrs, "fixed");
        int constraintType = 0;
        String constraintValue = null;
        if (def != null) {
            constraintType = 1;
            constraintValue = def;
        } else if (fixed != null) {
            constraintType = 2;
            constraintValue = fixed;
        }
        String attrName = XMLSchemaBuilder.getAttribute(attrs, "name");
        String attrNamespace = XMLSchemaBuilder.getAttribute(attrs, "targetNamespace");
        String ref = XMLSchemaBuilder.getAttribute(attrs, "ref");
        String use = XMLSchemaBuilder.getAttribute(attrs, "use");
        String type = XMLSchemaBuilder.getAttribute(attrs, "type");
        SimpleType datatype = type == null ? null : this.parseSimpleType(XMLSchemaBuilder.asQName(type, node2));
        Annotation annotation = null;
        Node child = node2.getFirstChild();
        while (child != null) {
            String uri = child.getNamespaceURI();
            String name = child.getLocalName();
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) && child.getNodeType() == 1) {
                if ("annotation".equals(name)) {
                    annotation = this.parseAnnotation(child);
                } else if ("simpleType".equals(name)) {
                    datatype = this.parseSimpleType(child);
                }
            }
            child = child.getNextSibling();
        }
        if (scope) {
            return new AttributeDeclaration(scope, constraintType, constraintValue, new QName(attrNamespace, attrName), datatype, annotation);
        }
        boolean required = "required".equals(use);
        AttributeDeclaration decl = ref == null ? new AttributeDeclaration(scope, 0, null, new QName(attrNamespace, attrName), datatype, annotation) : null;
        return new AttributeUse(required, constraintType, constraintValue, decl);
    }

    int parseFullDerivationSet(String value) {
        int ret = 0;
        if ("#all".equals(value)) {
            ret = 15;
        } else {
            StringTokenizer st = new StringTokenizer(value, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("extension".equals(token)) {
                    ret |= 1;
                    continue;
                }
                if ("restriction".equals(token)) {
                    ret |= 2;
                    continue;
                }
                if ("list".equals(token)) {
                    ret |= 4;
                    continue;
                }
                if (!"union".equals(token)) continue;
                ret |= 8;
            }
        }
        return ret;
    }

    int parseSimpleTypeDerivationSet(String value) {
        int ret = 0;
        if ("#all".equals(value)) {
            ret = 14;
        } else {
            StringTokenizer st = new StringTokenizer(value, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("list".equals(token)) {
                    ret |= 4;
                    continue;
                }
                if ("union".equals(token)) {
                    ret |= 8;
                    continue;
                }
                if (!"restriction".equals(token)) continue;
                ret |= 2;
            }
        }
        return ret;
    }

    int parseComplexTypeDerivationSet(String value) {
        int ret = 0;
        if ("#all".equals(value)) {
            ret = 3;
        } else {
            StringTokenizer st = new StringTokenizer(value, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("extension".equals(token)) {
                    ret |= 1;
                    continue;
                }
                if (!"restriction".equals(token)) continue;
                ret |= 2;
            }
        }
        return ret;
    }

    int parseBlockSet(String value) {
        int ret = 0;
        if ("#all".equals(value)) {
            ret = 7;
        } else {
            StringTokenizer st = new StringTokenizer(value, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("extension".equals(token)) {
                    ret |= 1;
                    continue;
                }
                if ("restriction".equals(token)) {
                    ret |= 2;
                    continue;
                }
                if (!"substitution".equals(token)) continue;
                ret |= 4;
            }
        }
        return ret;
    }

    int parseComplexTypeBlockSet(String value) {
        int ret = 0;
        if ("#all".equals(value)) {
            ret = 3;
        } else {
            StringTokenizer st = new StringTokenizer(value, " ");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if ("extension".equals(token)) {
                    ret |= 1;
                    continue;
                }
                if (!"restriction".equals(token)) continue;
                ret |= 2;
            }
        }
        return ret;
    }

    Object parseElement(Node node2, ElementDeclaration parent) throws DatatypeException {
        String block;
        String ref;
        boolean notTopLevel;
        NamedNodeMap attrs = node2.getAttributes();
        Integer minOccurs = null;
        Integer maxOccurs = null;
        Node parentNode = node2.getParentNode();
        boolean bl = notTopLevel = !"schema".equals(parentNode.getLocalName());
        if (notTopLevel && (ref = XMLSchemaBuilder.getAttribute(attrs, "ref")) != null) {
            minOccurs = this.getOccurrence(XMLSchemaBuilder.getAttribute(attrs, "minOccurs"));
            maxOccurs = this.getOccurrence(XMLSchemaBuilder.getAttribute(attrs, "maxOccurs"));
            Object ad = null;
            return new Particle(minOccurs, maxOccurs, ad);
        }
        String elementName = XMLSchemaBuilder.getAttribute(attrs, "name");
        String elementNamespace = XMLSchemaBuilder.getAttribute(attrs, "targetNamespace");
        String type = XMLSchemaBuilder.getAttribute(attrs, "type");
        SimpleType datatype = type != null ? this.parseSimpleType(XMLSchemaBuilder.asQName(type, node2)) : null;
        int scope = parent == null ? 0 : 1;
        String def = XMLSchemaBuilder.getAttribute(attrs, "default");
        String fixed = XMLSchemaBuilder.getAttribute(attrs, "fixed");
        int constraintType = 0;
        String constraintValue = null;
        if (def != null) {
            constraintType = 1;
            constraintValue = def;
        } else if (fixed != null) {
            constraintType = 2;
            constraintValue = fixed;
        }
        String sg = XMLSchemaBuilder.getAttribute(attrs, "substitutionGroup");
        QName substitutionGroup = QName.valueOf(sg);
        String sgPrefix = substitutionGroup.getPrefix();
        if (sgPrefix != null && !"".equals(sgPrefix)) {
            String sgName = substitutionGroup.getLocalPart();
            String sgNamespace = node2.lookupNamespaceURI(sgPrefix);
            substitutionGroup = new QName(sgNamespace, sgName);
        }
        int substitutionGroupExclusions = (block = XMLSchemaBuilder.getAttribute(attrs, "block")) == null ? this.schema.blockDefault : this.parseBlockSet(block);
        String final_ = XMLSchemaBuilder.getAttribute(attrs, "final");
        int disallowedSubstitutions = final_ == null ? this.schema.finalDefault : this.parseFullDerivationSet(final_);
        boolean nillable = "true".equals(XMLSchemaBuilder.getAttribute(attrs, "nillable"));
        boolean isAbstract = "true".equals(XMLSchemaBuilder.getAttribute(attrs, "abstract"));
        if (notTopLevel) {
            minOccurs = this.getOccurrence(XMLSchemaBuilder.getAttribute(attrs, "minOccurs"));
            maxOccurs = this.getOccurrence(XMLSchemaBuilder.getAttribute(attrs, "maxOccurs"));
            String form = XMLSchemaBuilder.getAttribute(attrs, "form");
            if (form != null) {
                if ("qualified".equals(form)) {
                    elementNamespace = this.schema.targetNamespace;
                }
            } else if (this.schema.elementFormQualified) {
                elementNamespace = this.schema.targetNamespace;
            }
        }
        ElementDeclaration ed = new ElementDeclaration(new QName(elementNamespace, elementName), datatype, scope, parent, constraintType, constraintValue, nillable, substitutionGroup, substitutionGroupExclusions, disallowedSubstitutions, isAbstract);
        Node child = node2.getFirstChild();
        while (child != null) {
            String uri = child.getNamespaceURI();
            String name = child.getLocalName();
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) && child.getNodeType() == 1) {
                if ("annotation".equals(name)) {
                    ed.annotation = this.parseAnnotation(child);
                } else if ("simpleType".equals(name) && datatype == null) {
                    ed.datatype = this.parseSimpleType(child);
                } else if ("complexType".equals(name) && datatype == null) {
                    ed.datatype = this.parseComplexType(child, ed);
                }
            }
            child = child.getNextSibling();
        }
        if (notTopLevel) {
            return new Particle(minOccurs, maxOccurs, ed);
        }
        return ed;
    }

    Integer getOccurrence(String value) {
        if (value == null) {
            return new Integer(1);
        }
        if ("unbounded".equals(value)) {
            return null;
        }
        return new Integer(value);
    }

    SimpleType parseSimpleType(QName typeName) throws DatatypeException {
        SimpleType cfr_ignored_0 = (SimpleType)this.schema.types.get(typeName);
        if (!"http://www.w3.org/2001/XMLSchema".equals(typeName.getNamespaceURI())) {
            return null;
        }
        String localName = typeName.getLocalPart();
        return (SimpleType)this.typeLibrary.createDatatype(localName);
    }

    SimpleType parseSimpleType(Node simpleType) throws DatatypeException {
        NamedNodeMap attrs = simpleType.getAttributes();
        String typeFinal = XMLSchemaBuilder.getAttribute(attrs, "final");
        if (typeFinal == null) {
            Node schema = simpleType.getParentNode();
            while (schema != null && !"schema".equals(schema.getLocalName())) {
                schema = schema.getParentNode();
            }
            if (schema != null) {
                NamedNodeMap schemaAttrs = schema.getAttributes();
                typeFinal = XMLSchemaBuilder.getAttribute(schemaAttrs, "finalDefault");
            }
        }
        this.parseSimpleTypeDerivationSet(typeFinal);
        QName typeName = XMLSchemaBuilder.asQName(XMLSchemaBuilder.getAttribute(attrs, "name"), simpleType);
        int variety = 0;
        LinkedHashSet facets = new LinkedHashSet();
        int fundamentalFacets = 0;
        SimpleType baseType = null;
        Annotation annotation = null;
        Node child = simpleType.getFirstChild();
        while (child != null) {
            String uri = child.getNamespaceURI();
            String name = child.getLocalName();
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) && child.getNodeType() == 1) {
                if ("annotation".equals(name)) {
                    annotation = this.parseAnnotation(child);
                } else if (!"restriction".equals(name)) {
                    if ("list".equals(name)) {
                        variety = 2;
                    } else if ("union".equals(name)) {
                        variety = 3;
                    }
                }
            }
            child = child.getNextSibling();
        }
        return new SimpleType(typeName, variety, facets, fundamentalFacets, baseType, annotation);
    }

    Type parseComplexType(Node complexType, ElementDeclaration parent) throws DatatypeException {
        NamedNodeMap attrs = complexType.getAttributes();
        QName typeName = XMLSchemaBuilder.asQName(XMLSchemaBuilder.getAttribute(attrs, "name"), complexType);
        boolean isAbstract = "true".equals(XMLSchemaBuilder.getAttribute(attrs, "abstract"));
        String block = XMLSchemaBuilder.getAttribute(attrs, "block");
        int prohibitedSubstitutions = block == null ? this.schema.blockDefault : this.parseComplexTypeBlockSet(block);
        String final_ = XMLSchemaBuilder.getAttribute(attrs, "final");
        int finality = final_ == null ? this.schema.finalDefault : this.parseComplexTypeDerivationSet(final_);
        ComplexType type = new ComplexType(typeName, isAbstract, prohibitedSubstitutions, finality);
        boolean mixed = "true".equals(XMLSchemaBuilder.getAttribute(attrs, "mixed"));
        Node child = complexType.getFirstChild();
        while (child != null) {
            String uri = child.getNamespaceURI();
            String name = child.getLocalName();
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) && child.getNodeType() == 1 && "simpleContent".equals(name)) {
                this.parseSimpleContent(child, type);
            }
            child = child.getNextSibling();
        }
        if (mixed) {
            type.contentType = 2;
        }
        return type;
    }

    void parseSimpleContent(Node simpleContent, ComplexType type) throws DatatypeException {
        Node child = simpleContent.getFirstChild();
        while (child != null) {
            String uri = child.getNamespaceURI();
            String name = child.getLocalName();
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) && child.getNodeType() == 1) {
                if ("annotation".equals(name)) {
                    type.annotations.add(this.parseAnnotation(child));
                } else if ("restriction".equals(name)) {
                    type.derivationMethod = 2;
                    this.parseRestriction(child, type);
                } else if ("extension".equals(name)) {
                    type.derivationMethod = 1;
                    this.parseExtension(child, type);
                }
            }
            child = child.getNextSibling();
        }
    }

    void parseRestriction(Node restriction, ComplexType type) throws DatatypeException {
        NamedNodeMap attrs = restriction.getAttributes();
        String base = XMLSchemaBuilder.getAttribute(attrs, "base");
        XMLSchemaBuilder.asQName(base, restriction);
        Node child = restriction.getFirstChild();
        while (child != null) {
            String uri = child.getNamespaceURI();
            String name = child.getLocalName();
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) && child.getNodeType() == 1) {
                if ("annotation".equals(name)) {
                    type.annotations.add(this.parseAnnotation(child));
                } else if ("simpleType".equals(name)) {
                    type.contentType = 1;
                    this.parseSimpleType(child);
                } else if (!("minExclusive".equals(name) || "minInclusive".equals(name) || "maxExclusive".equals(name) || "maxInclusive".equals(name) || "totalDigits".equals(name) || "fractionDigits".equals(name) || "length".equals(name) || "minLength".equals(name) || "maxLength".equals(name) || "enumeration".equals(name) || "whiteSpace".equals(name) || "pattern".equals(name))) {
                    if ("attribute".equals(name)) {
                        AttributeUse use = (AttributeUse)this.parseAttribute(child, false);
                        this.schema.attributeDeclarations.put(use.declaration.name, use.declaration);
                        type.attributeUses.add(use);
                    } else if ("attributeGroup".equals(name)) {
                        NamedNodeMap agAttrs = child.getAttributes();
                        String ref = XMLSchemaBuilder.getAttribute(agAttrs, "ref");
                        QName ag = XMLSchemaBuilder.asQName(ref, child);
                        type.attributeUses.add(ag);
                    } else if ("anyAttribute".equals(name)) {
                        type.attributeWildcard = this.parseAnyAttribute(child);
                    }
                }
            }
            child = child.getNextSibling();
        }
    }

    void parseExtension(Node extension, ComplexType type) throws DatatypeException {
        NamedNodeMap attrs = extension.getAttributes();
        String base = XMLSchemaBuilder.getAttribute(attrs, "base");
        XMLSchemaBuilder.asQName(base, extension);
        Node child = extension.getFirstChild();
        while (child != null) {
            String uri = child.getNamespaceURI();
            String name = child.getLocalName();
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) && child.getNodeType() == 1) {
                if ("annotation".equals(name)) {
                    type.annotations.add(this.parseAnnotation(child));
                } else if ("attribute".equals(name)) {
                    AttributeUse use = (AttributeUse)this.parseAttribute(child, false);
                    this.schema.attributeDeclarations.put(use.declaration.name, use.declaration);
                    type.attributeUses.add(use);
                } else if ("attributeGroup".equals(name)) {
                    NamedNodeMap agAttrs = child.getAttributes();
                    String ref = XMLSchemaBuilder.getAttribute(agAttrs, "ref");
                    QName ag = XMLSchemaBuilder.asQName(ref, child);
                    type.attributeUses.add(ag);
                } else if ("anyAttribute".equals(name)) {
                    type.attributeWildcard = this.parseAnyAttribute(child);
                }
            }
            child = child.getNextSibling();
        }
    }

    AnyAttribute parseAnyAttribute(Node node2) {
        NamedNodeMap attrs = node2.getAttributes();
        String namespace = XMLSchemaBuilder.getAttribute(attrs, "namespace");
        String pc = XMLSchemaBuilder.getAttribute(attrs, "processContents");
        int processContents = 0;
        if ("lax".equals(pc)) {
            processContents = 1;
        } else if ("skip".equals(pc)) {
            processContents = 2;
        }
        AnyAttribute ret = new AnyAttribute(namespace, processContents);
        Node child = node2.getFirstChild();
        while (child != null) {
            String uri = child.getNamespaceURI();
            String name = child.getLocalName();
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) && child.getNodeType() == 1 && "annotation".equals(name)) {
                ret.annotation = this.parseAnnotation(child);
            }
            child = child.getNextSibling();
        }
        return ret;
    }

    Annotation parseAnnotation(Node node2) {
        return null;
    }

    private static String getAttribute(NamedNodeMap attrs, String name) {
        Node attr = attrs.getNamedItem(name);
        return attr == null ? null : attr.getNodeValue();
    }

    private static QName asQName(String text, Node resolver) {
        QName name = QName.valueOf(text);
        String prefix = name.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            String uri = resolver.lookupNamespaceURI(prefix);
            name = new QName(uri, name.getLocalPart());
        }
        return name;
    }
}

