/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public final class StringContent
implements AbstractDocument.Content,
Serializable {
    private static final long serialVersionUID = 4755994433709540381L;
    char[] content;
    private int count;
    Vector marks;
    private static final char[] EMPTY = new char[0];
    ReferenceQueue queueOfDeath = new ReferenceQueue();

    public StringContent() {
        this(10);
    }

    public StringContent(int initialLength) {
        if (initialLength < 1) {
            initialLength = 1;
        }
        this.content = new char[initialLength];
        this.content[0] = 10;
        this.count = 1;
    }

    protected Vector getPositionsInRange(Vector v, int offset, int length) {
        Vector refPos = v == null ? new Vector() : v;
        for (Mark m : this.marks) {
            if (offset > m.mark || m.mark > offset + length) continue;
            refPos.add(new UndoPosRef(m));
        }
        return refPos;
    }

    public Position createPosition(int offset) throws BadLocationException {
        if (this.marks == null) {
            this.marks = new Vector();
        }
        StickyPosition sp = new StickyPosition(offset);
        return sp;
    }

    public int length() {
        return this.count;
    }

    public UndoableEdit insertString(int where, String str) throws BadLocationException {
        this.checkLocation(where, 0);
        if (where == this.count) {
            throw new BadLocationException("Invalid location", 1);
        }
        if (str == null) {
            throw new NullPointerException();
        }
        char[] insert = str.toCharArray();
        this.replace(where, 0, insert);
        if (this.marks != null) {
            Iterator iter = this.marks.iterator();
            int start = where;
            if (start == 0) {
                start = 1;
            }
            while (iter.hasNext()) {
                Mark m = (Mark)iter.next();
                if (m.mark < start) continue;
                m.mark += str.length();
            }
        }
        InsertUndo iundo = new InsertUndo(where, insert.length);
        return iundo;
    }

    public UndoableEdit remove(int where, int nitems) throws BadLocationException {
        this.checkLocation(where, nitems + 1);
        RemoveUndo rundo = new RemoveUndo(where, new String(this.content, where, nitems));
        this.replace(where, nitems, EMPTY);
        if (this.marks != null) {
            for (Mark m : this.marks) {
                if (m.mark >= where + nitems) {
                    m.mark -= nitems;
                    continue;
                }
                if (m.mark < where) continue;
                m.mark = where;
            }
        }
        return rundo;
    }

    private void replace(int offs, int numRemove, char[] insert) {
        int insertLength = insert.length;
        int delta = insertLength - numRemove;
        int src = offs + numRemove;
        int numMove = this.count - src;
        int dest = src + delta;
        if (this.count + delta >= this.content.length) {
            int newLength = Math.max(2 * this.content.length, this.count + delta);
            char[] newContent = new char[newLength];
            System.arraycopy(this.content, 0, newContent, 0, offs);
            System.arraycopy(insert, 0, newContent, offs, insertLength);
            System.arraycopy(this.content, src, newContent, dest, numMove);
            this.content = newContent;
        } else {
            System.arraycopy(this.content, src, this.content, dest, numMove);
            System.arraycopy(insert, 0, this.content, offs, insertLength);
        }
        this.count += delta;
    }

    public String getString(int where, int len) throws BadLocationException {
        this.checkLocation(where, len);
        return new String(this.content, where, len);
    }

    public void getChars(int where, int len, Segment txt) throws BadLocationException {
        if (where + len > this.count) {
            throw new BadLocationException("Invalid location", where + len);
        }
        txt.array = this.content;
        txt.offset = where;
        txt.count = len;
    }

    protected void updateUndoPositions(Vector positions) {
        for (UndoPosRef pos : positions) {
            pos.reset();
        }
    }

    void checkLocation(int where, int len) throws BadLocationException {
        if (where < 0) {
            throw new BadLocationException("Invalid location", 1);
        }
        if (where > this.count) {
            throw new BadLocationException("Invalid location", this.count);
        }
        if (where + len > this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
    }

    void garbageCollect() {
        Reference ref = this.queueOfDeath.poll();
        while (ref != null) {
            if (ref != null) {
                StickyPosition pos = (StickyPosition)ref.get();
                Mark m = pos.mark;
                --m.refCount;
                if (m.refCount == 0) {
                    this.marks.remove(m);
                }
            }
            ref = this.queueOfDeath.poll();
        }
    }

    private class InsertUndo
    extends AbstractUndoableEdit {
        private int start;
        private int length;
        private String redoContent;
        private Vector positions;

        public InsertUndo(int start, int length) {
            this.start = start;
            this.length = length;
        }

        public void undo() {
            super.undo();
            try {
                if (StringContent.this.marks != null) {
                    this.positions = StringContent.this.getPositionsInRange(null, this.start, this.length);
                }
                this.redoContent = StringContent.this.getString(this.start, this.length);
                StringContent.this.remove(this.start, this.length);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            super.redo();
            try {
                StringContent.this.insertString(this.start, this.redoContent);
                this.redoContent = null;
                if (this.positions != null) {
                    StringContent.this.updateUndoPositions(this.positions);
                    this.positions = null;
                }
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    private class Mark {
        int mark;
        int refCount;

        Mark(int offset) {
            this.mark = offset;
        }
    }

    private class RemoveUndo
    extends AbstractUndoableEdit {
        private int start;
        private int len;
        private String undoString;
        Vector positions;

        public RemoveUndo(int start, String str) {
            this.start = start;
            this.len = str.length();
            this.undoString = str;
            if (StringContent.this.marks != null) {
                this.positions = StringContent.this.getPositionsInRange(null, start, str.length());
            }
        }

        public void undo() {
            super.undo();
            try {
                StringContent.this.insertString(this.start, this.undoString);
                if (this.positions != null) {
                    StringContent.this.updateUndoPositions(this.positions);
                    this.positions = null;
                }
                this.undoString = null;
            }
            catch (BadLocationException badLocationException) {
                throw new CannotUndoException();
            }
        }

        public void redo() {
            super.redo();
            try {
                this.undoString = StringContent.this.getString(this.start, this.len);
                if (StringContent.this.marks != null) {
                    this.positions = StringContent.this.getPositionsInRange(null, this.start, this.len);
                }
                StringContent.this.remove(this.start, this.len);
            }
            catch (BadLocationException badLocationException) {
                throw new CannotRedoException();
            }
        }
    }

    private class StickyPosition
    implements Position {
        Mark mark;

        public StickyPosition(int offset) {
            StringContent.this.garbageCollect();
            this.mark = new Mark(offset);
            ++this.mark.refCount;
            StringContent.this.marks.add(this.mark);
            new WeakReference<StickyPosition>(this, StringContent.this.queueOfDeath);
        }

        public int getOffset() {
            return this.mark.mark;
        }
    }

    private class UndoPosRef {
        private Mark mark;
        private int undoOffset;

        UndoPosRef(Mark m) {
            this.mark = m;
            this.undoOffset = this.mark.mark;
        }

        void reset() {
            this.mark.mark = this.undoOffset;
        }
    }
}

