/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final long serialVersionUID = -7720805057305804111L;
    int used;
    E[] storage;
    Comparator<? super E> comparator;

    public PriorityQueue() {
        this(11, null);
    }

    public PriorityQueue(Collection<? extends E> c) {
        this(Math.max(1, (int)(1.1 * (double)c.size())), null);
        if (c instanceof SortedSet) {
            SortedSet ss = (SortedSet)c;
            this.comparator = ss.comparator();
            int i = 0;
            for (Object val : ss) {
                if (val == null) {
                    throw new NullPointerException();
                }
                this.storage[i++] = val;
            }
        } else if (c instanceof PriorityQueue) {
            PriorityQueue pq = (PriorityQueue)c;
            this.comparator = pq.comparator();
            System.arraycopy(pq.storage, 0, this.storage, 0, pq.storage.length);
        }
        this.addAll(c);
    }

    public PriorityQueue(int cap) {
        this(cap, null);
    }

    public PriorityQueue(int cap, Comparator<? super E> comp) {
        if (cap < 1) {
            throw new IllegalArgumentException();
        }
        this.used = 0;
        this.storage = new Object[cap];
        this.comparator = comp;
    }

    public PriorityQueue(PriorityQueue<? extends E> c) {
        this(Math.max(1, (int)(1.1 * (double)c.size())), c.comparator());
        System.arraycopy(c.storage, 0, this.storage, 0, c.storage.length);
    }

    public PriorityQueue(SortedSet<? extends E> c) {
        this(Math.max(1, (int)(1.1 * (double)c.size())), c.comparator());
        int i = 0;
        for (Object val : c) {
            if (val == null) {
                throw new NullPointerException();
            }
            this.storage[i++] = val;
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.storage, null);
        this.used = 0;
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int index = -1;
            int count = 0;

            @Override
            public boolean hasNext() {
                return this.count < PriorityQueue.this.used;
            }

            @Override
            public E next() {
                while (PriorityQueue.this.storage[++this.index] == null) {
                }
                ++this.count;
                return PriorityQueue.this.storage[this.index];
            }

            @Override
            public void remove() {
                PriorityQueue.this.remove(this.index);
                --this.index;
            }
        };
    }

    @Override
    public boolean offer(E o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int slot = this.findSlot(-1);
        this.storage[slot] = o;
        ++this.used;
        this.bubbleUp(slot);
        return true;
    }

    @Override
    public E peek() {
        return this.used == 0 ? null : (E)this.storage[0];
    }

    @Override
    public E poll() {
        if (this.used == 0) {
            return null;
        }
        E result = this.storage[0];
        this.remove(0);
        return result;
    }

    @Override
    public boolean remove(Object o) {
        if (o != null) {
            int i = 0;
            while (i < this.storage.length) {
                if (o.equals(this.storage[i])) {
                    this.remove(i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public int size() {
        return this.used;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int newSlot = -1;
        int save = this.used;
        for (E val : c) {
            if (val == null) {
                throw new NullPointerException();
            }
            newSlot = this.findSlot(newSlot);
            this.storage[newSlot] = val;
            ++this.used;
            this.bubbleUp(newSlot);
        }
        return save != this.used;
    }

    int findSlot(int start) {
        int slot;
        if (this.used == this.storage.length) {
            this.resize();
            slot = this.used;
        } else {
            slot = start + 1;
            while (slot < this.storage.length) {
                if (this.storage[slot] == null) break;
                ++slot;
            }
        }
        return slot;
    }

    void remove(int index) {
        while (this.storage[index] != null) {
            int child = 2 * index + 1;
            if (child >= this.storage.length) {
                this.storage[index] = null;
                break;
            }
            if (child + 1 < this.storage.length && this.storage[child + 1] != null && (this.storage[child] == null || Collections.compare(this.storage[child], this.storage[child + 1], this.comparator) > 0)) {
                ++child;
            }
            this.storage[index] = this.storage[child];
            index = child;
        }
        --this.used;
    }

    void bubbleUp(int index) {
        while (index > 0) {
            int parent = (index - 1) / 2;
            if (Collections.compare(this.storage[parent], this.storage[index], this.comparator) <= 0) break;
            E temp = this.storage[index];
            this.storage[index] = this.storage[parent];
            this.storage[parent] = temp;
            index = parent;
        }
    }

    void resize() {
        Object[] new_data = new Object[2 * this.storage.length];
        System.arraycopy(this.storage, 0, new_data, 0, this.storage.length);
        this.storage = new_data;
    }
}

